/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.ringbuffer.LongRingBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class AggregatingLongRingBuffer {
    private final LongRingBuffer internalBuffer;
    private final LongFunction aggInitialFunction;
    private final LongFunction aggTreeFunction;
    private final long identityVal;
    private static long defaultValueForThisType;
    private long[] treeStorage;
    private long calcHead = 0L;
    private long calcTail = 0L;

    public AggregatingLongRingBuffer(int capacity, long identityVal, @NotNull LongFunction aggFunction) {
        this(capacity, identityVal, aggFunction, aggFunction, true);
    }

    public AggregatingLongRingBuffer(int capacity, long identityVal, @NotNull LongFunction aggTreeFunction, @NotNull LongFunction aggInitialFunction) {
        this(capacity, identityVal, aggTreeFunction, aggInitialFunction, true);
    }

    public AggregatingLongRingBuffer(int capacity, long identityVal, @NotNull LongFunction aggTreeFunction, @NotNull LongFunction aggInitialFunction, boolean growable) {
        this.internalBuffer = new LongRingBuffer(capacity, growable);
        this.aggTreeFunction = aggTreeFunction;
        this.aggInitialFunction = aggInitialFunction;
        this.identityVal = identityVal;
        this.treeStorage = new long[this.internalBuffer.storage.length];
        if (identityVal != defaultValueForThisType) {
            Arrays.fill(this.treeStorage, identityVal);
            Arrays.fill(this.internalBuffer.storage, identityVal);
        }
    }

    protected void grow(int increase) {
        this.internalBuffer.grow(increase);
        this.treeStorage = new long[this.internalBuffer.storage.length];
        if (this.identityVal != defaultValueForThisType) {
            Arrays.fill(this.treeStorage, this.identityVal);
            Arrays.fill(this.internalBuffer.storage, this.internalBuffer.size(), this.internalBuffer.storage.length, this.identityVal);
        }
        this.calcTail = 0L;
        this.calcHead = 0L;
    }

    public boolean isFull() {
        return this.internalBuffer.isFull();
    }

    public boolean isEmpty() {
        return this.internalBuffer.isEmpty();
    }

    public int size() {
        return this.internalBuffer.size();
    }

    public int capacity() {
        return this.internalBuffer.capacity();
    }

    public int remaining() {
        return this.internalBuffer.remaining();
    }

    public void add(long e) {
        if (this.isFull()) {
            if (!this.internalBuffer.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
    }

    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.internalBuffer.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public long addOverwrite(long e, long notFullResult) {
        long val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(long e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public long remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public long poll(long onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public long element() {
        return this.internalBuffer.element();
    }

    public long peek(long onEmpty) {
        return this.internalBuffer.peek(onEmpty);
    }

    public long front() {
        return this.front(0);
    }

    public long front(int offset) {
        return this.internalBuffer.front(offset);
    }

    public long back() {
        return this.internalBuffer.back();
    }

    public long peekBack(long onEmpty) {
        return this.internalBuffer.peekBack(onEmpty);
    }

    public long[] getAll() {
        return this.internalBuffer.getAll();
    }

    public void addUnsafe(long e) {
        if (this.internalBuffer.tail >= 0x4000000000000000L) {
            long length = this.calcTail - this.calcHead;
            this.calcHead &= (long)this.internalBuffer.mask;
            this.calcTail = this.calcHead + length;
            length = this.internalBuffer.tail - this.internalBuffer.head;
            this.internalBuffer.head = (this.internalBuffer.head & (long)this.internalBuffer.mask) + (long)this.internalBuffer.storage.length;
            this.internalBuffer.tail = this.internalBuffer.head + length;
        }
        this.internalBuffer.addUnsafe(e);
    }

    public void addIdentityValue() {
        this.add(this.identityVal);
    }

    public long removeUnsafe() {
        long prevHead = this.internalBuffer.head;
        long val = this.internalBuffer.removeUnsafe();
        int idx = (int)(prevHead & (long)this.internalBuffer.mask);
        this.internalBuffer.storage[idx] = this.identityVal;
        return val;
    }

    public long[] remove(int count) {
        long prevHead = this.internalBuffer.head;
        long[] result = this.internalBuffer.remove(count);
        this.fillWithIdentityVal(prevHead, count);
        return result;
    }

    public void clear() {
        long prevHead = this.internalBuffer.head;
        int prevSize = this.size();
        this.internalBuffer.tail = 0L;
        this.internalBuffer.head = 0L;
        this.calcTail = 0L;
        this.calcHead = 0L;
        this.fillWithIdentityVal(prevHead, prevSize);
        Arrays.fill(this.treeStorage, this.identityVal);
    }

    private void fillWithIdentityVal(long head, int count) {
        int storageHead = (int)(head & (long)this.internalBuffer.mask);
        int firstCopyLen = Math.min(this.internalBuffer.storage.length - storageHead, count);
        int secondCopyLen = count - firstCopyLen;
        Arrays.fill(this.internalBuffer.storage, storageHead, storageHead + firstCopyLen, this.identityVal);
        Arrays.fill(this.internalBuffer.storage, 0, secondCopyLen, this.identityVal);
    }

    public long evaluate() {
        long intersectionSize = this.calcTail > this.internalBuffer.head ? this.calcTail - this.internalBuffer.head : 0L;
        long r1Head = this.calcHead;
        long r1Tail = this.calcTail - intersectionSize;
        long r2Head = this.internalBuffer.head + intersectionSize;
        long r2Tail = this.internalBuffer.tail;
        long newBase = r1Head;
        r1Head -= newBase;
        r1Tail -= newBase;
        long r2Size = (r2Tail -= newBase) - (r2Head -= newBase);
        if ((r2Tail = (r2Head &= (long)this.internalBuffer.mask) + r2Size) <= (long)this.internalBuffer.storage.length) {
            if (r2Tail <= r1Tail) {
                r2Tail = 0L;
                r2Head = 0L;
            } else if (r2Head <= r1Tail) {
                r1Tail = r2Tail;
                r2Tail = 0L;
                r2Head = 0L;
            }
        } else {
            r1Head = Math.min(r1Head, r2Head - (long)this.internalBuffer.storage.length) + (long)this.internalBuffer.storage.length;
            r1Tail = Math.max(r2Tail, r2Tail - (long)this.internalBuffer.storage.length) + (long)this.internalBuffer.storage.length;
            r2Tail = 0L;
            r2Head = 0L;
        }
        if ((r1Tail += newBase) - (r1Head += newBase) >= (long)this.internalBuffer.storage.length || (r2Tail += newBase) - (r2Head += newBase) >= (long)this.internalBuffer.storage.length) {
            this.fixupTree(0L, this.internalBuffer.storage.length, 0L, 0L);
        } else {
            this.fixupTree(r1Head, r1Tail, r2Head, r2Tail);
        }
        this.calcHead = this.internalBuffer.head;
        this.calcTail = this.internalBuffer.tail;
        return this.treeStorage[1];
    }

    void fixupTree(long r1Head, long r1Tail, long r2Head, long r2Tail) {
        int r2t;
        int r2h;
        int r1t;
        int r1h;
        int r2TailNormal;
        int r2HeadNormal;
        int r1TailNormal;
        int r1HeadNormal;
        long r1Size = r1Tail - r1Head;
        long r2Size = r2Tail - r2Head;
        int offset = this.internalBuffer.storage.length / 2;
        if (r1Size == 0L && r2Size == 0L) {
            return;
        }
        if (r2Size == 0L) {
            r1HeadNormal = (int)(r1Head & (long)this.internalBuffer.mask);
            r1TailNormal = (int)((long)r1HeadNormal + r1Size);
            if (r1TailNormal <= this.internalBuffer.storage.length) {
                int r1h2 = r1HeadNormal;
                int r1t2 = r1TailNormal - 1;
                this.evaluateAndStoreResults(r1h2, r1t2, this.internalBuffer.storage, offset, this.aggInitialFunction);
                this.evaluateRange(offset + r1h2 / 2, offset + r1t2 / 2, this.aggTreeFunction);
                return;
            }
            boolean r1h3 = false;
            int r1t3 = r1TailNormal - this.internalBuffer.storage.length - 1;
            int r2h2 = r1HeadNormal;
            int r2t2 = this.internalBuffer.storage.length - 1;
            this.evaluateAndStoreResults(0, r1t3, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateAndStoreResults(r2h2, r2t2, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateTwoRanges(offset + 0, offset + r1t3 / 2, offset + r2h2 / 2, offset + r2t2 / 2, this.aggTreeFunction);
        }
        int r1HeadTmp = (int)(r1Head & (long)this.internalBuffer.mask);
        int r1TailTmp = (int)((long)r1HeadTmp + r1Size);
        int r2HeadTmp = (int)(r2Head & (long)this.internalBuffer.mask);
        int r2TailTmp = (int)((long)r2HeadTmp + r2Size);
        if (r1HeadTmp <= r2HeadTmp) {
            r1HeadNormal = r1HeadTmp;
            r1TailNormal = r1TailTmp;
            r2HeadNormal = r2HeadTmp;
            r2TailNormal = r2TailTmp;
        } else {
            r1HeadNormal = r2HeadTmp;
            r1TailNormal = r2TailTmp;
            r2HeadNormal = r1HeadTmp;
            r2TailNormal = r1TailTmp;
        }
        if (r1TailNormal <= this.internalBuffer.storage.length && r2TailNormal <= this.internalBuffer.storage.length) {
            r1h = r1HeadNormal;
            r1t = r1TailNormal - 1;
            r2h = r2HeadNormal;
            r2t = r2TailNormal - 1;
            this.evaluateAndStoreResults(r1h, r1t, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateAndStoreResults(r2h, r2t, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateTwoRanges(offset + r1h / 2, offset + r1t / 2, offset + r2h / 2, offset + r2t / 2, this.aggTreeFunction);
            return;
        }
        if (r1TailNormal <= this.internalBuffer.storage.length) {
            r1h = 0;
            r1t = r2TailNormal - this.internalBuffer.storage.length - 1;
            r2h = r1HeadNormal;
            r2t = r1TailNormal - 1;
            int r3h = r2HeadNormal;
            int r3t = this.internalBuffer.storage.length - 1;
            this.evaluateAndStoreResults(0, r1t, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateAndStoreResults(r2h, r2t, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateAndStoreResults(r3h, r3t, this.internalBuffer.storage, offset, this.aggInitialFunction);
            this.evaluateThreeRanges(offset + 0, offset + r1t / 2, offset + r2h / 2, offset + r2t / 2, offset + r3h / 2, offset + r3t / 2, this.aggTreeFunction);
            return;
        }
        r1h = 0;
        r1t = r1TailNormal - this.internalBuffer.storage.length - 1;
        r2h = r2HeadNormal;
        r2t = r2TailNormal - 1;
        int r3h = r1HeadNormal;
        int r3t = this.internalBuffer.storage.length - 1;
        this.evaluateAndStoreResults(0, r1t, this.internalBuffer.storage, offset, this.aggInitialFunction);
        this.evaluateAndStoreResults(r2h, r2t, this.internalBuffer.storage, offset, this.aggInitialFunction);
        this.evaluateAndStoreResults(r3h, r3t, this.internalBuffer.storage, offset, this.aggInitialFunction);
        this.evaluateThreeRanges(offset + 0, offset + r1t / 2, offset + r2h / 2, offset + r2t / 2, offset + r3h / 2, offset + r3t / 2, this.aggTreeFunction);
    }

    private void evaluateThreeRanges(int r1h, int r1t, int r2h, int r2t, int r3h, int r3t, LongFunction evalFunction) {
        while (true) {
            if (r1t >= r2h) {
                this.evaluateTwoRanges(r1h, r2t, r3h, r3t, evalFunction);
                return;
            }
            if (r2t >= r3h) {
                this.evaluateTwoRanges(r1h, r1t, r2h, r3t, evalFunction);
                return;
            }
            this.evaluateAndStoreResults(r1h, r1t, this.treeStorage, 0, evalFunction);
            this.evaluateAndStoreResults(r2h, r2t, this.treeStorage, 0, evalFunction);
            this.evaluateAndStoreResults(r3h, r3t, this.treeStorage, 0, evalFunction);
            r1h /= 2;
            r1t /= 2;
            r2h /= 2;
            r2t /= 2;
            r3h /= 2;
            r3t /= 2;
        }
    }

    private void evaluateTwoRanges(int r1h, int r1t, int r2h, int r2t, LongFunction evalFunction) {
        while (true) {
            if (r1t >= r2h) {
                this.evaluateRange(r1h, r2t, evalFunction);
                return;
            }
            this.evaluateAndStoreResults(r1h, r1t, this.treeStorage, 0, evalFunction);
            this.evaluateAndStoreResults(r2h, r2t, this.treeStorage, 0, evalFunction);
            r1h /= 2;
            r1t /= 2;
            r2h /= 2;
            r2t /= 2;
        }
    }

    private void evaluateRange(int r1h, int r1t, LongFunction evalFunction) {
        while (r1t > 1) {
            this.evaluateAndStoreResults(r1h, r1t, this.treeStorage, 0, evalFunction);
            r1h /= 2;
            r1t /= 2;
        }
    }

    private void evaluateAndStoreResults(int start, int end, long[] src, int dstOffset, LongFunction evalFunction) {
        for (int left = start & 0xFFFFFFFE; left <= end; left += 2) {
            long computeVal;
            int right = left + 1;
            int parent = left / 2;
            long leftVal = src[left];
            long rightVal = src[right];
            this.treeStorage[parent + dstOffset] = computeVal = evalFunction.apply(leftVal, rightVal);
        }
    }

    @FunctionalInterface
    public static interface LongFunction {
        public long apply(long var1, long var3);
    }
}

