/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.ringbuffer.RingBuffer;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.TestOnly;

public class CharRingBuffer
implements RingBuffer,
Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    char[] storage;
    int mask;
    long head;
    long tail;

    public CharRingBuffer(int capacity) {
        this(capacity, true);
    }

    public CharRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "CharRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new char[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "CharRingBuffer capacity", 0x40000000L);
        char[] newStorage = new char[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(char[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    @Override
    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    @Override
    public int capacity() {
        return this.storage.length;
    }

    @Override
    public int remaining() {
        return this.storage.length - this.size();
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(char e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    @Override
    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(char e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public char addOverwrite(char e, char notFullResult) {
        char val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(char e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public char[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        char[] result = new char[count];
        this.copyRingBufferToArray(result);
        this.head += (long)count;
        return result;
    }

    public char remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public char removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        char val = this.storage[idx];
        return val;
    }

    public char poll(char onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public char element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public char peek(char onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public char front() {
        return this.front(0);
    }

    public char front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public char back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public char peekBack(char onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public char[] getAll() {
        char[] result = new char[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @TestOnly
    public char[] getStorage() {
        return this.storage;
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < CharRingBuffer.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return CharRingBuffer.this.storage[(int)(CharRingBuffer.this.head + (long)this.cursor & (long)CharRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

