/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.ringbuffer.RingBuffer;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.TestOnly;

public class LongRingBuffer
implements RingBuffer,
Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    long[] storage;
    int mask;
    long head;
    long tail;

    public LongRingBuffer(int capacity) {
        this(capacity, true);
    }

    public LongRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "LongRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new long[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "LongRingBuffer capacity", 0x40000000L);
        long[] newStorage = new long[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(long[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    @Override
    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    @Override
    public int capacity() {
        return this.storage.length;
    }

    @Override
    public int remaining() {
        return this.storage.length - this.size();
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(long e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    @Override
    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(long e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public long addOverwrite(long e, long notFullResult) {
        long val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(long e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public long[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        long[] result = new long[count];
        this.copyRingBufferToArray(result);
        this.head += (long)count;
        return result;
    }

    public long remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public long removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        long val = this.storage[idx];
        return val;
    }

    public long poll(long onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public long element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public long peek(long onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public long front() {
        return this.front(0);
    }

    public long front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public long back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public long peekBack(long onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public long[] getAll() {
        long[] result = new long[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @TestOnly
    public long[] getStorage() {
        return this.storage;
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < LongRingBuffer.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return LongRingBuffer.this.storage[(int)(LongRingBuffer.this.head + (long)this.cursor & (long)LongRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

