/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.ringbuffer.ByteRingBuffer;
import io.deephaven.base.ringbuffer.CharRingBuffer;
import io.deephaven.base.ringbuffer.DoubleRingBuffer;
import io.deephaven.base.ringbuffer.FloatRingBuffer;
import io.deephaven.base.ringbuffer.IntRingBuffer;
import io.deephaven.base.ringbuffer.LongRingBuffer;
import io.deephaven.base.ringbuffer.ObjectRingBuffer;
import io.deephaven.base.ringbuffer.ShortRingBuffer;
import org.jetbrains.annotations.NotNull;

public interface RingBuffer {
    @NotNull
    public static <T> RingBuffer makeRingBuffer(@NotNull Class<?> dataType, int capacity, boolean growable) {
        RingBuffer result = dataType == Character.TYPE || dataType == Character.class ? new CharRingBuffer(capacity, growable) : (dataType == Byte.TYPE || dataType == Byte.class ? new ByteRingBuffer(capacity, growable) : (dataType == Double.TYPE || dataType == Double.class ? new DoubleRingBuffer(capacity, growable) : (dataType == Float.TYPE || dataType == Float.class ? new FloatRingBuffer(capacity, growable) : (dataType == Integer.TYPE || dataType == Integer.class ? new IntRingBuffer(capacity, growable) : (dataType == Long.TYPE || dataType == Long.class ? new LongRingBuffer(capacity, growable) : (dataType == Short.TYPE || dataType == Short.class ? new ShortRingBuffer(capacity, growable) : new ObjectRingBuffer(capacity, growable)))))));
        return result;
    }

    public boolean isFull();

    public boolean isEmpty();

    public int size();

    public int capacity();

    public int remaining();

    public void clear();

    public void ensureRemaining(int var1);
}

