/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.Group;
import io.deephaven.base.stats.ItemUpdateListener;
import io.deephaven.base.stats.Value;

public class Item<V extends Value> {
    protected final String name;
    protected final String description;
    protected final Group group;
    protected final V value;
    protected final String compactName;

    Item(Group group, String name, V value, String description) {
        this.name = name;
        this.description = description;
        this.group = group;
        this.value = value;
        this.compactName = group.getName() + "." + name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Group getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.group.getName();
    }

    public V getValue() {
        return this.value;
    }

    public String getCompactName() {
        return this.compactName;
    }

    public void update(ItemUpdateListener listener, long logInterval, long now, long appNow) {
        ((Value)this.value).update(this, listener, logInterval, now, appNow);
    }
}

