/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Require;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public enum EncodingInfo implements LogOutputAppendable
{
    US_ASCII(StandardCharsets.US_ASCII, true),
    ISO_8859_1(StandardCharsets.ISO_8859_1, true),
    UTF_8(StandardCharsets.UTF_8, false),
    UTF_16BE(StandardCharsets.UTF_16BE, false),
    UTF_16LE(StandardCharsets.UTF_16LE, false),
    UTF_16(StandardCharsets.UTF_16, false);

    private final Charset charset;
    private final String encodingName;
    private final boolean isSimple;
    private final ThreadLocal<SoftReference<CharsetEncoder>> encoder;
    private final ThreadLocal<SoftReference<CharsetDecoder>> decoder;

    private EncodingInfo(Charset charset, String encodingName, boolean isSimple) {
        this.charset = Require.neqNull(charset, "charSet");
        this.encodingName = Require.neqNull(encodingName, "encodingName");
        this.isSimple = isSimple;
        this.encoder = ThreadLocal.withInitial(() -> new SoftReference<CharsetEncoder>(this.makeEncoder()));
        this.decoder = ThreadLocal.withInitial(() -> new SoftReference<CharsetDecoder>(this.makeDecoder()));
    }

    private EncodingInfo(Charset charset, boolean isSimple) {
        this(charset, charset.name(), isSimple);
    }

    private EncodingInfo(String encodingName, boolean isSimple) {
        this(Charset.forName(encodingName), encodingName, isSimple);
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private CharsetEncoder makeEncoder() {
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public CharsetEncoder getEncoder() {
        CharsetEncoder encoder = this.encoder.get().get();
        if (encoder == null) {
            encoder = this.makeEncoder();
            this.encoder.set(new SoftReference<CharsetEncoder>(encoder));
        }
        return encoder;
    }

    private CharsetDecoder makeDecoder() {
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public CharsetDecoder getDecoder() {
        CharsetDecoder decoder = this.decoder.get().get();
        if (decoder == null) {
            decoder = this.makeDecoder();
            this.decoder.set(new SoftReference<CharsetDecoder>(decoder));
        }
        return decoder;
    }

    public byte[] encode(@NotNull String value) {
        return value.getBytes(this.charset);
    }

    public String decode(@NotNull byte[] value) {
        return new String(value, this.charset);
    }

    public String decode(@NotNull byte[] value, int offset, int length) {
        return new String(value, offset, length, this.charset);
    }

    @Override
    public LogOutput append(@NotNull LogOutput logOutput) {
        return logOutput.append(this.encodingName);
    }
}

