/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.CompressedString;
import io.deephaven.base.string.cache.MappedCompressedString;
import io.deephaven.base.string.cache.StringCache;
import io.deephaven.base.string.cache.StringCacheTypeAdapter;
import io.deephaven.base.string.cache.StringCacheTypeAdapterCompressedStringImpl;
import io.deephaven.base.string.cache.StringCacheTypeAdapterMappedCompressedStringImpl;
import io.deephaven.base.string.cache.StringCacheTypeAdapterStringImpl;
import io.deephaven.base.string.cache.StringCompatible;
import io.deephaven.base.verify.Require;
import org.jetbrains.annotations.NotNull;

public class AlwaysCreateStringCache<STRING_LIKE_TYPE extends CharSequence>
implements StringCache<STRING_LIKE_TYPE> {
    public static final StringCache<String> STRING_INSTANCE = new AlwaysCreateStringCache<String>(StringCacheTypeAdapterStringImpl.INSTANCE);
    public static final StringCache<CompressedString> COMPRESSED_STRING_INSTANCE = new AlwaysCreateStringCache<CompressedString>(StringCacheTypeAdapterCompressedStringImpl.INSTANCE);
    public static final StringCache<MappedCompressedString> MAPPED_COMPRESSED_STRING_INSTANCE = new AlwaysCreateStringCache<MappedCompressedString>(StringCacheTypeAdapterMappedCompressedStringImpl.INSTANCE);
    private final StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter;

    private AlwaysCreateStringCache(StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter) {
        this.typeAdapter = Require.neqNull(typeAdapter, "typeAdapter");
    }

    @Override
    public final int capacity() {
        return 0;
    }

    @Override
    @NotNull
    public final Class<STRING_LIKE_TYPE> getType() {
        return this.typeAdapter.getType();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getEmptyString() {
        return this.typeAdapter.empty();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull StringCompatible protoString) {
        return this.typeAdapter.create(protoString);
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull String string) {
        return this.typeAdapter.create(string);
    }
}

