/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.ByteOrientedCharSequenceAdapter;
import io.deephaven.base.string.cache.CompressedString;
import io.deephaven.base.string.cache.MappedCompressedString;
import org.jetbrains.annotations.NotNull;

public class ByteArrayCharSequenceAdapterImpl
extends ByteOrientedCharSequenceAdapter {
    private byte[] byteArray;
    private int offset;
    private int length;

    @Override
    @NotNull
    public CompressedString toCompressedString() {
        return new CompressedString(this.byteArray, this.offset, this.length);
    }

    @Override
    @NotNull
    public MappedCompressedString toMappedCompressedString() {
        return new MappedCompressedString(this.byteArray, this.offset, this.length);
    }

    public final ByteArrayCharSequenceAdapterImpl set(byte[] byteArray, int offset, int length) {
        this.byteArray = byteArray;
        this.offset = offset;
        this.length = length;
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final ByteArrayCharSequenceAdapterImpl clear() {
        this.byteArray = null;
        this.offset = 0;
        this.length = 0;
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final char charAt(int index) {
        return (char)(this.byteArray[this.offset + index] & 0xFF);
    }
}

