/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.ByteOrientedCharSequenceAdapter;
import io.deephaven.base.string.cache.CompressedString;
import io.deephaven.base.string.cache.MappedCompressedString;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ByteBufferCharSequenceAdapterImpl
extends ByteOrientedCharSequenceAdapter {
    private ByteBuffer buffer;
    private int offset;
    private int length;

    @Override
    @NotNull
    public CompressedString toCompressedString() {
        return new CompressedString(this.buffer, this.offset, this.length);
    }

    @Override
    @NotNull
    public MappedCompressedString toMappedCompressedString() {
        return new MappedCompressedString(this.buffer, this.offset, this.length);
    }

    public final ByteBufferCharSequenceAdapterImpl set(ByteBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final ByteBufferCharSequenceAdapterImpl clear() {
        this.buffer = null;
        this.offset = 0;
        this.length = 0;
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final char charAt(int index) {
        return (char)(this.buffer.get(this.offset + index) & 0xFF);
    }
}

