/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.cache.KeyedObjectCache;
import io.deephaven.base.string.cache.StringCache;
import io.deephaven.base.string.cache.StringCacheTypeAdapter;
import io.deephaven.base.string.cache.StringCompatible;
import io.deephaven.base.verify.Require;
import io.deephaven.hash.KeyedObjectKey;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class ConcurrentBoundedStringCache<STRING_LIKE_TYPE extends CharSequence>
implements StringCache<STRING_LIKE_TYPE> {
    private final StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter;
    private final KeyedObjectCache<CharSequence, STRING_LIKE_TYPE> cache;

    public ConcurrentBoundedStringCache(StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter, int capacity, int collisionFactor) {
        this.typeAdapter = Require.neqNull(typeAdapter, "typeAdapter");
        this.cache = new KeyedObjectCache(capacity, collisionFactor, new KeyImpl(), null, new Random());
    }

    @Override
    public final int capacity() {
        return this.cache.getCapacity();
    }

    @Override
    @NotNull
    public final Class<STRING_LIKE_TYPE> getType() {
        return this.typeAdapter.getType();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getEmptyString() {
        return this.typeAdapter.empty();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull StringCompatible protoString) {
        CharSequence existingValue = (CharSequence)this.cache.get(protoString);
        return (STRING_LIKE_TYPE)(existingValue != null ? existingValue : (CharSequence)this.cache.putIfAbsent(this.typeAdapter.create(protoString)));
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull String string) {
        CharSequence existingValue = (CharSequence)this.cache.get(string);
        return (STRING_LIKE_TYPE)(existingValue != null ? existingValue : (CharSequence)this.cache.putIfAbsent(this.typeAdapter.create(string)));
    }

    private class KeyImpl
    implements KeyedObjectKey<CharSequence, STRING_LIKE_TYPE> {
        private KeyImpl() {
        }

        public CharSequence getKey(STRING_LIKE_TYPE value) {
            return value;
        }

        public int hashKey(CharSequence key) {
            return key.hashCode();
        }

        public boolean equalKey(CharSequence key, STRING_LIKE_TYPE value) {
            return ConcurrentBoundedStringCache.this.typeAdapter.areEqual(key, value);
        }
    }
}

