/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class CacheDir {
    public static final String PROPERTY = "deephaven.cacheDir";
    public static final String ENV_VAR = "DEEPHAVEN_CACHE_DIR";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    public static Path get() {
        return CacheDir.getOptional().map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(CacheDir::viaTmpDir);
    }

    public static Path getOrSet(String defaultValue) {
        String existing = CacheDir.getOptional().orElse(null);
        if (existing != null) {
            return Paths.get(existing, new String[0]);
        }
        System.setProperty(PROPERTY, defaultValue);
        return Paths.get(defaultValue, new String[0]);
    }

    private static Optional<String> getOptional() {
        Optional<String> optional = CacheDir.viaProperty();
        if (!optional.isPresent()) {
            optional = CacheDir.viaEnvVar();
        }
        return optional;
    }

    private static Optional<String> viaProperty() {
        return Optional.ofNullable(System.getProperty(PROPERTY));
    }

    private static Optional<String> viaEnvVar() {
        return Optional.ofNullable(System.getenv(ENV_VAR));
    }

    private static Path viaTmpDir() {
        return Paths.get(System.getProperty(JAVA_IO_TMPDIR), "deephaven", "cache");
    }
}

