/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class ConfigDir {
    public static final String PROPERTY = "deephaven.configDir";
    public static final String ENV_VAR = "DEEPHAVEN_CONFIG_DIR";
    static final String ROOT_FILE_PROP = "Configuration.rootFile";
    private static final String DEFAULT_CONFIG_FILE_NAME = "deephaven.prop";
    private static final String DEFAULT_CONFIGURATION_FILE = "dh-defaults.prop";

    public static Optional<Path> get() {
        return ConfigDir.getOptional().map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static Path getOrSet(String defaultValue) {
        String existing = ConfigDir.getOptional().orElse(null);
        if (existing != null) {
            return Paths.get(existing, new String[0]);
        }
        System.setProperty(PROPERTY, defaultValue);
        return Paths.get(defaultValue, new String[0]);
    }

    public static String configurationFile() {
        Optional<String> optional = Optional.ofNullable(System.getProperty(ROOT_FILE_PROP));
        if (!optional.isPresent()) {
            optional = ConfigDir.configDirectoryFileIfExists();
        }
        return optional.orElse(DEFAULT_CONFIGURATION_FILE);
    }

    private static Optional<String> configDirectoryFileIfExists() {
        return ConfigDir.get().map(ConfigDir::defaultFileName).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toString);
    }

    private static Optional<String> getOptional() {
        Optional<String> optional = ConfigDir.viaProperty();
        if (!optional.isPresent()) {
            optional = ConfigDir.viaEnvVar();
        }
        return optional;
    }

    private static Path defaultFileName(Path p) {
        return p.resolve(DEFAULT_CONFIG_FILE_NAME);
    }

    private static Optional<String> viaProperty() {
        return Optional.ofNullable(System.getProperty(PROPERTY));
    }

    private static Optional<String> viaEnvVar() {
        return Optional.ofNullable(System.getenv(ENV_VAR));
    }
}

