/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class DataDir {
    public static final String PROPERTY = "deephaven.dataDir";
    @Deprecated
    private static final String WORKSPACE_PROPERTY = "workspace";
    public static final String ENV_VAR = "DEEPHAVEN_DATA_DIR";
    private static final String DEFAULT_DATA_DIR = ".";

    public static Path get() {
        return Paths.get(DataDir.getOptional().orElse(DEFAULT_DATA_DIR), new String[0]);
    }

    public static Path getOrSet(String defaultValue) {
        String existing = DataDir.getOptional().orElse(null);
        if (existing != null) {
            return Paths.get(existing, new String[0]);
        }
        System.setProperty(PROPERTY, defaultValue);
        return Paths.get(defaultValue, new String[0]);
    }

    private static Optional<String> getOptional() {
        Optional<String> optional = DataDir.viaProperty();
        if (!optional.isPresent()) {
            optional = DataDir.viaWorkspace();
        }
        if (!optional.isPresent()) {
            optional = DataDir.viaEnvironmentVariable();
        }
        return optional;
    }

    private static Optional<String> viaProperty() {
        return Optional.ofNullable(System.getProperty(PROPERTY));
    }

    private static Optional<String> viaWorkspace() {
        return Optional.ofNullable(System.getProperty(WORKSPACE_PROPERTY));
    }

    private static Optional<String> viaEnvironmentVariable() {
        return Optional.ofNullable(System.getenv(ENV_VAR));
    }
}

