/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import io.deephaven.configuration.ConfigurationContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DefaultConfigurationContext
implements ConfigurationContext {
    private static final String HOSTNAME = "host";
    static final String PROCESS_NAME_PROPERTY = "process";
    private final Map<String, String> contextItems = new HashMap<String, String>();
    private final Collection<String> hostOptions = new ArrayList<String>();

    public DefaultConfigurationContext() {
        this.contextItems.put(PROCESS_NAME_PROPERTY, this.getSystemProperty("process.name"));
    }

    @Override
    public boolean matches(String token, List<String> targetValues) {
        if (token.toLowerCase().equals(HOSTNAME)) {
            if (this.hostOptions.isEmpty()) {
                this.populateHostnames();
            }
            for (String aHostName : this.hostOptions) {
                if (!targetValues.contains(aHostName.toLowerCase())) continue;
                return true;
            }
            return false;
        }
        String contextValue = this.getContextItem(token);
        if (contextValue == null) {
            return false;
        }
        return targetValues.contains(contextValue);
    }

    private String getContextItem(String token) {
        if (this.contextItems.containsKey(token)) {
            return this.contextItems.get(token);
        }
        return this.getSystemProperty(token);
    }

    private void populateHostnames() {
        try {
            int dotPosition;
            InetAddress address = InetAddress.getLocalHost();
            String hostName = address.getHostName();
            this.hostOptions.add(hostName);
            String numericalAddress = address.getHostAddress();
            this.hostOptions.add(numericalAddress);
            String fqdn = address.getCanonicalHostName();
            if (!fqdn.equals(numericalAddress)) {
                this.hostOptions.add(address.getCanonicalHostName());
            }
            if ((dotPosition = hostName.indexOf(".")) > 0) {
                this.hostOptions.add(address.getHostName().substring(0, dotPosition));
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Unable to get current host name. Host-specific configuration items will be ignored.");
        }
    }

    private String getSystemProperty(String propertyName) {
        String propVal = System.getProperty(propertyName);
        if (propVal != null) {
            this.contextItems.put(propertyName, propVal);
        }
        return propVal;
    }

    @Override
    public Collection<String> getContextKeyValues() {
        return Collections.unmodifiableCollection(new HashSet<String>(this.contextItems.keySet()));
    }
}

