/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import io.deephaven.configuration.PropertyInputStreamLoader;
import io.deephaven.configuration.PropertyInputStreamLoaderTraditional;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PropertyInputStreamLoaderFactory {
    public static PropertyInputStreamLoader newInstance() {
        List loaders = StreamSupport.stream(ServiceLoader.load(PropertyInputStreamLoader.class).spliterator(), false).collect(Collectors.toList());
        if (loaders.isEmpty()) {
            String message = String.format("Unable to find any provided implementations for %s. This should not happen - we expect at least %s to be on the classpath.", PropertyInputStreamLoader.class.getName(), PropertyInputStreamLoaderTraditional.class.getName());
            throw new IllegalStateException(message);
        }
        long distinctCount = loaders.stream().mapToLong(PropertyInputStreamLoader::getPriority).distinct().count();
        if (distinctCount != (long)loaders.size()) {
            String propertyInputStreamLoadersDebugInfo = loaders.stream().map(c -> c.getClass().getName() + ":" + c.getPriority()).collect(Collectors.joining(",", "[", "]"));
            String message = String.format("Unable to return the appropriate %s - at least two of the implementations have equal priorities, and that is not allowed. %s", PropertyInputStreamLoader.class.getName(), propertyInputStreamLoadersDebugInfo);
            throw new IllegalStateException(message);
        }
        return loaders.stream().min(Comparator.comparing(PropertyInputStreamLoader::getPriority)).get();
    }
}

