/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.graphite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import java.net.InetSocketAddress;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

@JsonTypeName(value="graphite")
public class GraphiteReporterFactory
extends BaseReporterFactory {
    @NotEmpty
    private String host = "localhost";
    @Range(min=0L, max=49151L)
    private int port = 8080;
    @NotNull
    private String prefix = "";

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        Graphite graphite = new Graphite(new InetSocketAddress(this.host, this.port));
        return GraphiteReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).prefixedWith(this.getPrefix()).build(graphite);
    }
}

