/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;

public class WatchEnricher
extends BaseEnricher {
    public WatchEnricher(EnricherContext buildContext) {
        super(buildContext, "f8-watch");
    }

    public void adapt(KubernetesListBuilder builder) {
        if (this.getContext().isWatchMode()) {
            this.scaleDownToOnePod(builder);
        }
    }

    private void scaleDownToOnePod(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder b) {
                ((ReplicaSetFluent.SpecNested)b.editOrNewSpec().withReplicas(Integer.valueOf(1))).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder b) {
                ((ReplicationControllerFluent.SpecNested)b.editOrNewSpec().withReplicas(Integer.valueOf(1))).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder b) {
                ((DeploymentFluent.SpecNested)b.editOrNewSpec().withReplicas(Integer.valueOf(1))).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder b) {
                ((DeploymentConfigFluent.SpecNested)b.editOrNewSpec().withReplicas(Integer.valueOf(1))).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder b) {
                ((StatefulSetFluent.SpecNested)b.editOrNewSpec().withReplicas(Integer.valueOf(1))).endSpec();
            }
        });
    }
}

