/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.netty.channel.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class HttpClientConfig {
    private long connectTimeout = 5000L;
    private Charset defaultCharset = StandardCharsets.UTF_8;
    private boolean enableZeroCopy = true;
    private boolean useOpenSsl;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private long handshakeTimeout = 10000L;
    private boolean enableSni;
    private boolean enableHostnameVerification;
    private String[] enabledSslProtocols;
    private String[] enabledSslCipherSuites;
    private int sslSessionCacheSize;
    private long sslSessionTimeout;
    private boolean disableSslSessionResumption;
    private boolean filterInsecureCipherSuites;
    private boolean useNativeTransport;
    private long channelPoolIdleTimeout = 30000L;
    private long channelPoolIdleCleanerPeriod = 1000L;
    private Consumer<Channel> additionalChannelInitializer;
    private boolean tcpNoDelay;
    private boolean soReuseAddress;
    private int maxRetry;
    private int webSocketMaxFramePayloadLength;
    private String threadPoolName = "gatling-http-client";

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpClientConfig setConnectTimeout(long l) {
        this.connectTimeout = l;
        return this;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public HttpClientConfig setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
        return this;
    }

    public boolean isEnableZeroCopy() {
        return this.enableZeroCopy;
    }

    public HttpClientConfig setEnableZeroCopy(boolean bl) {
        this.enableZeroCopy = bl;
        return this;
    }

    public boolean isUseOpenSsl() {
        return this.useOpenSsl;
    }

    public HttpClientConfig setUseOpenSsl(boolean bl) {
        this.useOpenSsl = bl;
        return this;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public HttpClientConfig setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public HttpClientConfig setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public HttpClientConfig setHandshakeTimeout(long l) {
        this.handshakeTimeout = l;
        return this;
    }

    public boolean isEnableSni() {
        return this.enableSni;
    }

    public HttpClientConfig setEnableSni(boolean bl) {
        this.enableSni = bl;
        return this;
    }

    public boolean isEnableHostnameVerification() {
        return this.enableHostnameVerification;
    }

    public HttpClientConfig setEnableHostnameVerification(boolean bl) {
        this.enableHostnameVerification = bl;
        return this;
    }

    public String[] getEnabledSslProtocols() {
        return this.enabledSslProtocols;
    }

    public HttpClientConfig setEnabledSslProtocols(String[] stringArray) {
        this.enabledSslProtocols = stringArray;
        return this;
    }

    public String[] getEnabledSslCipherSuites() {
        return this.enabledSslCipherSuites;
    }

    public HttpClientConfig setEnabledSslCipherSuites(String[] stringArray) {
        this.enabledSslCipherSuites = stringArray;
        return this;
    }

    public boolean isFilterInsecureCipherSuites() {
        return this.filterInsecureCipherSuites;
    }

    public HttpClientConfig setFilterInsecureCipherSuites(boolean bl) {
        this.filterInsecureCipherSuites = bl;
        return this;
    }

    public HttpClientConfig setUseNativeTransport(boolean bl) {
        this.useNativeTransport = bl;
        return this;
    }

    public boolean isUseNativeTransport() {
        return this.useNativeTransport;
    }

    public HttpClientConfig setChannelPoolIdleTimeout(long l) {
        this.channelPoolIdleTimeout = l;
        return this;
    }

    public long getChannelPoolIdleTimeout() {
        return this.channelPoolIdleTimeout;
    }

    public HttpClientConfig setChannelPoolIdleCleanerPeriod(long l) {
        this.channelPoolIdleCleanerPeriod = l;
        return this;
    }

    public long getChannelPoolIdleCleanerPeriod() {
        return this.channelPoolIdleCleanerPeriod;
    }

    public HttpClientConfig setAdditionalChannelInitializer(Consumer<Channel> consumer) {
        this.additionalChannelInitializer = consumer;
        return this;
    }

    public Consumer<Channel> getAdditionalChannelInitializer() {
        return this.additionalChannelInitializer;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public HttpClientConfig setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
        return this;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public HttpClientConfig setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
        return this;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public HttpClientConfig setMaxRetry(int n) {
        this.maxRetry = n;
        return this;
    }

    public int getWebSocketMaxFramePayloadLength() {
        return this.webSocketMaxFramePayloadLength;
    }

    public HttpClientConfig setWebSocketMaxFramePayloadLength(int n) {
        this.webSocketMaxFramePayloadLength = n;
        return this;
    }

    public int getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public HttpClientConfig setSslSessionCacheSize(int n) {
        this.sslSessionCacheSize = n;
        return this;
    }

    public long getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public HttpClientConfig setSslSessionTimeout(long l) {
        this.sslSessionTimeout = l;
        return this;
    }

    public boolean isDisableSslSessionResumption() {
        return this.disableSslSessionResumption;
    }

    public HttpClientConfig setDisableSslSessionResumption(boolean bl) {
        this.disableSslSessionResumption = bl;
        return this;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public HttpClientConfig setThreadPoolName(String string) {
        this.threadPoolName = string;
        return this;
    }
}

