/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.pool;

import io.gatling.http.client.ahc.util.Assertions;
import io.gatling.http.client.pool.ChannelPoolKey;
import io.gatling.http.client.pool.CoalescingChannelPool;
import io.gatling.http.client.pool.IpAndPort;
import io.gatling.http.client.pool.RemoteKey;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    private static final AttributeKey<ChannelPoolKey> CHANNEL_POOL_KEY_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"poolKey");
    private static final AttributeKey<Long> CHANNEL_POOL_TIMESTAMP_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"poolTimestamp");
    private static final AttributeKey<Integer> CHANNEL_POOL_STREAM_COUNT_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"poolStreamCount");
    static final int INITIAL_CLIENT_MAP_SIZE = 1000;
    static final int INITIAL_KEY_PER_CLIENT_MAP_SIZE = 2;
    static final int INITIAL_CHANNEL_QUEUE_SIZE = 2;
    private final Map<Long, Map<RemoteKey, Queue<Channel>>> channels = new HashMap<Long, Map<RemoteKey, Queue<Channel>>>(1000);
    private final CoalescingChannelPool coalescingChannelPool = new CoalescingChannelPool();

    private Queue<Channel> remoteChannels(ChannelPoolKey channelPoolKey) {
        return this.channels.computeIfAbsent(channelPoolKey.clientId, l -> new HashMap(2)).computeIfAbsent(channelPoolKey.remoteKey, remoteKey -> new ArrayDeque(2));
    }

    private static boolean isHttp1(Channel channel) {
        return channel.pipeline().get("app-http") != null;
    }

    public static boolean isHttp2(Channel channel) {
        return !ChannelPool.isHttp1(channel);
    }

    private void incrementStreamCount(Channel channel) {
        Attribute attribute = channel.attr(CHANNEL_POOL_STREAM_COUNT_ATTRIBUTE_KEY);
        attribute.set((Object)((Integer)attribute.get() + 1));
    }

    public Channel poll(ChannelPoolKey channelPoolKey) {
        Channel channel;
        Queue<Channel> queue = this.remoteChannels(channelPoolKey);
        while (true) {
            if ((channel = queue.peek()) == null) {
                return null;
            }
            if (channel.isActive()) break;
            queue.remove();
        }
        if (ChannelPool.isHttp1(channel)) {
            queue.remove();
            return channel;
        }
        this.incrementStreamCount(channel);
        return channel;
    }

    public Channel pollCoalescedChannel(long l, String string, List<InetSocketAddress> list) {
        Channel channel = this.coalescingChannelPool.getCoalescedChannel(l, string, list);
        if (channel != null) {
            LOGGER.debug("Retrieving channel from coalescing pool for domain {}", (Object)string);
            this.incrementStreamCount(channel);
        }
        return channel;
    }

    public void addCoalescedChannel(Set<String> set, InetSocketAddress inetSocketAddress, Channel channel, ChannelPoolKey channelPoolKey) {
        IpAndPort ipAndPort = new IpAndPort(inetSocketAddress.getAddress().getAddress(), inetSocketAddress.getPort());
        this.coalescingChannelPool.addEntry(channelPoolKey.clientId, ipAndPort, set, channel);
    }

    public void register(Channel channel, ChannelPoolKey channelPoolKey) {
        channel.attr(CHANNEL_POOL_KEY_ATTRIBUTE_KEY).set((Object)channelPoolKey);
    }

    private void touch(Channel channel) {
        channel.attr(CHANNEL_POOL_TIMESTAMP_ATTRIBUTE_KEY).set((Object)System.nanoTime());
    }

    public void offer(Channel channel) {
        ChannelPoolKey channelPoolKey = (ChannelPoolKey)channel.attr(CHANNEL_POOL_KEY_ATTRIBUTE_KEY).get();
        Assertions.assertNotNull(channelPoolKey, "Channel doesn't have a key");
        if (ChannelPool.isHttp1(channel)) {
            this.remoteChannels(channelPoolKey).offer(channel);
            this.touch(channel);
        } else {
            Attribute attribute = channel.attr(CHANNEL_POOL_STREAM_COUNT_ATTRIBUTE_KEY);
            Integer n = (Integer)attribute.get();
            if (n == null) {
                this.remoteChannels(channelPoolKey).offer(channel);
                attribute.set((Object)1);
            } else {
                attribute.set((Object)(n - 1));
                if (n == 1) {
                    this.touch(channel);
                }
            }
        }
    }

    public void closeIdleChannels(long l) {
        long l2 = System.nanoTime();
        for (Map.Entry<Long, Map<RemoteKey, Queue<Channel>>> entry : this.channels.entrySet()) {
            for (Map.Entry<RemoteKey, Queue<Channel>> entry2 : entry.getValue().entrySet()) {
                Queue<Channel> queue = entry2.getValue();
                for (Channel channel : queue) {
                    Integer n;
                    if (l2 - (Long)channel.attr(CHANNEL_POOL_TIMESTAMP_ATTRIBUTE_KEY).get() <= l || (n = (Integer)channel.attr(CHANNEL_POOL_STREAM_COUNT_ATTRIBUTE_KEY).get()) != null && n != 0) continue;
                    channel.close();
                    queue.remove(channel);
                    if (!ChannelPool.isHttp2(channel)) continue;
                    this.coalescingChannelPool.deleteIdleEntry(entry.getKey(), channel);
                }
            }
        }
    }

    public void flushClientIdChannelPoolPartitions(long l) {
        Map<RemoteKey, Queue<Channel>> map = this.channels.get(l);
        if (map != null) {
            map.entrySet().stream().flatMap(entry -> ((Queue)entry.getValue()).stream()).forEach(ChannelOutboundInvoker::close);
            this.channels.remove(l);
            this.coalescingChannelPool.deleteClientEntries(l);
        }
    }

    public String toString() {
        return "ChannelPool{channels=" + this.channels + ", coalescingChannelPool=" + this.coalescingChannelPool + '}';
    }
}

