/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.Metadata;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.function.Supplier;
import org.lognet.springboot.grpc.security.Constants;

public class AuthHeader
implements Constants {
    private final Supplier<ByteBuffer> tokenSupplier;
    private final String authScheme;
    private final boolean binaryFormat;

    public Metadata attach(Metadata metadataHeader) {
        ByteBuffer token = this.tokenSupplier.get();
        byte[] header = ByteBuffer.allocate(this.authScheme.length() + token.remaining() + 1).put(this.authScheme.getBytes()).put((byte)32).put(token).array();
        if (this.binaryFormat) {
            metadataHeader.put(Constants.AUTH_HEADER_BIN_KEY, (Object)header);
        } else {
            metadataHeader.put(Constants.AUTH_HEADER_KEY, (Object)new String(header));
        }
        return metadataHeader;
    }

    private static boolean $default$binaryFormat() {
        return true;
    }

    AuthHeader(Supplier<ByteBuffer> tokenSupplier, String authScheme, boolean binaryFormat) {
        this.tokenSupplier = tokenSupplier;
        this.authScheme = authScheme;
        this.binaryFormat = binaryFormat;
    }

    public static AuthHeaderBuilder builder() {
        return new AuthHeaderBuilder();
    }

    public static class AuthHeaderBuilder {
        private Supplier<ByteBuffer> tokenSupplier;
        private String authScheme;
        private boolean binaryFormat$set;
        private boolean binaryFormat$value;

        public AuthHeaderBuilder bearer() {
            return this.authScheme("Bearer");
        }

        public AuthHeaderBuilder basic() {
            return this.authScheme("Basic");
        }

        public AuthHeaderBuilder basic(String userName, byte[] password) {
            ByteBuffer buffer = ByteBuffer.allocate(userName.length() + password.length + 1).put(userName.getBytes()).put((byte)58).put(password);
            buffer.rewind();
            ByteBuffer token = Base64.getEncoder().encode(buffer);
            token.rewind();
            return this.authScheme("Basic").tokenSupplier(token::duplicate);
        }

        AuthHeaderBuilder() {
        }

        public AuthHeaderBuilder tokenSupplier(Supplier<ByteBuffer> tokenSupplier) {
            this.tokenSupplier = tokenSupplier;
            return this;
        }

        public AuthHeaderBuilder authScheme(String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        public AuthHeaderBuilder binaryFormat(boolean binaryFormat) {
            this.binaryFormat$value = binaryFormat;
            this.binaryFormat$set = true;
            return this;
        }

        public AuthHeader build() {
            boolean binaryFormat$value = this.binaryFormat$value;
            if (!this.binaryFormat$set) {
                binaryFormat$value = AuthHeader.$default$binaryFormat();
            }
            return new AuthHeader(this.tokenSupplier, this.authScheme, binaryFormat$value);
        }

        public String toString() {
            return "AuthHeader.AuthHeaderBuilder(tokenSupplier=" + this.tokenSupplier + ", authScheme=" + this.authScheme + ", binaryFormat$value=" + this.binaryFormat$value + ")";
        }
    }
}

