/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.SingletonSupplier;

public class GRpcServicesRegistry
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Supplier<Map<String, BindableService>> beanNameToServiceBean;
    private Supplier<Map<String, BindableService>> serviceNameToServiceBean;
    private Supplier<Collection<ServerInterceptor>> grpcGlobalInterceptors;
    private Supplier<Map<MethodDescriptor<?, ?>, GrpcServiceMethod>> descriptorToServiceMethod;
    private Supplier<Map<Method, MethodDescriptor<?, ?>>> methodToDescriptor;

    public Map<String, BindableService> getServiceNameToServiceBeanMap() {
        return this.serviceNameToServiceBean.get();
    }

    public Map<String, BindableService> getBeanNameToServiceBeanMap() {
        return this.beanNameToServiceBean.get();
    }

    Collection<ServerInterceptor> getGlobalInterceptors() {
        return this.grpcGlobalInterceptors.get();
    }

    public GrpcServiceMethod getGrpServiceMethod(MethodDescriptor<?, ?> descriptor) {
        return this.descriptorToServiceMethod.get().get(descriptor);
    }

    public MethodDescriptor<?, ?> getMethodDescriptor(Method method) {
        return this.methodToDescriptor.get().get(method);
    }

    private <T> Map<String, T> getBeanNamesByTypeWithAnnotation(Class<? extends Annotation> annotationType, Class<T> beanType) {
        return this.applicationContext.getBeansWithAnnotation(annotationType).entrySet().stream().filter(e -> beanType.isInstance(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> beanType.cast(e.getValue())));
    }

    public void afterPropertiesSet() throws Exception {
        this.descriptorToServiceMethod = SingletonSupplier.of(this::descriptorToServiceMethod);
        this.methodToDescriptor = SingletonSupplier.of(() -> this.descriptorToServiceMethod.get().entrySet().stream().collect(Collectors.toMap(e -> ((GrpcServiceMethod)e.getValue()).getMethod(), Map.Entry::getKey)));
        this.beanNameToServiceBean = SingletonSupplier.of(() -> this.getBeanNamesByTypeWithAnnotation(GRpcService.class, BindableService.class));
        this.serviceNameToServiceBean = SingletonSupplier.of(() -> this.beanNameToServiceBean.get().values().stream().collect(Collectors.toMap(s -> s.bindService().getServiceDescriptor().getName(), Function.identity())));
        this.grpcGlobalInterceptors = SingletonSupplier.of(() -> this.getBeanNamesByTypeWithAnnotation(GRpcGlobalInterceptor.class, ServerInterceptor.class).values());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Map<MethodDescriptor<?, ?>, GrpcServiceMethod> descriptorToServiceMethod() {
        HashMap<MethodDescriptor, GrpcServiceMethod> map = new HashMap<MethodDescriptor, GrpcServiceMethod>();
        Function<String, ReflectionUtils.MethodFilter> filterFactory = name -> method -> method.getName().equalsIgnoreCase(name.replaceAll("_", ""));
        for (BindableService service : this.getBeanNameToServiceBeanMap().values()) {
            ServerServiceDefinition serviceDefinition = service.bindService();
            block5: for (MethodDescriptor d : serviceDefinition.getServiceDescriptor().getMethods()) {
                Class<?> abstractBaseClass = service.getClass();
                while (!Modifier.isAbstract(abstractBaseClass.getModifiers())) {
                    abstractBaseClass = abstractBaseClass.getSuperclass();
                }
                Set methods = MethodIntrospector.selectMethods(abstractBaseClass, (ReflectionUtils.MethodFilter)filterFactory.apply(d.getBareMethodName()));
                switch (methods.size()) {
                    case 0: {
                        throw new IllegalStateException("Method " + d.getBareMethodName() + "not found in service " + serviceDefinition.getServiceDescriptor().getName());
                    }
                    case 1: {
                        map.put(d, GrpcServiceMethod.builder().service(service).method((Method)methods.iterator().next()).build());
                        continue block5;
                    }
                }
                throw new IllegalStateException("Ambiguous method " + d.getBareMethodName() + " in service " + serviceDefinition.getServiceDescriptor().getName());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static class GrpcServiceMethod {
        private BindableService service;
        private Method method;

        GrpcServiceMethod(BindableService service, Method method) {
            this.service = service;
            this.method = method;
        }

        public static GrpcServiceMethodBuilder builder() {
            return new GrpcServiceMethodBuilder();
        }

        public BindableService getService() {
            return this.service;
        }

        public Method getMethod() {
            return this.method;
        }

        public static class GrpcServiceMethodBuilder {
            private BindableService service;
            private Method method;

            GrpcServiceMethodBuilder() {
            }

            public GrpcServiceMethodBuilder service(BindableService service) {
                this.service = service;
                return this;
            }

            public GrpcServiceMethodBuilder method(Method method) {
                this.method = method;
                return this;
            }

            public GrpcServiceMethod build() {
                return new GrpcServiceMethod(this.service, this.method);
            }

            public String toString() {
                return "GRpcServicesRegistry.GrpcServiceMethod.GrpcServiceMethodBuilder(service=" + this.service + ", method=" + this.method + ")";
            }
        }
    }
}

