/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.annotation;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMulti;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CacheAsMultiParameterDetail {
    private static final ExpressionParser PARSER = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.OFF, null));
    private final Class<?> rawType;
    private final int position;
    private final Annotation[] annotations;
    private final boolean strictNull;
    @Nullable
    private final Expression asElementFieldExpression;

    public CacheAsMultiParameterDetail(Method method, int position) {
        Parameter parameter = method.getParameters()[position];
        this.annotations = parameter.getAnnotations();
        this.rawType = parameter.getType();
        this.position = position;
        CacheAsMulti annotation = parameter.getAnnotation(CacheAsMulti.class);
        this.strictNull = annotation.strictNull();
        this.asElementFieldExpression = StringUtils.hasLength((String)annotation.asElementField()) ? PARSER.parseExpression("#this." + annotation.asElementField()) : null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CacheAsMultiParameterDetail(rawType=" + this.getRawType() + ", position=" + this.getPosition() + ", annotations=" + Arrays.deepToString(this.annotations) + ", strictNull=" + this.isStrictNull() + ", asElementFieldExpression=" + this.getAsElementFieldExpression() + ")";
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isStrictNull() {
        return this.strictNull;
    }

    @Nullable
    public Expression getAsElementFieldExpression() {
        return this.asElementFieldExpression;
    }
}

