/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.lang.Nullable;

public class EnhancedCachePostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(EnhancedCachePostProcessor.class);
    @Nullable
    protected BeanFactory beanFactory;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registerCacheRelatedBeanDefinition(registry, CacheMatchingBeanNames.CACHING);
        if (registry.containsBeanDefinition(CacheMatchingBeanNames.JCACHE.factoryBeanName)) {
            this.registerCacheRelatedBeanDefinition(registry, CacheMatchingBeanNames.JCACHE);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private void registerCacheRelatedBeanDefinition(BeanDefinitionRegistry registry, CacheMatchingBeanNames beanNames) throws BeansException {
        BeanDefinition cacheInterceptor;
        BeanDefinition cacheOperationSource = registry.getBeanDefinition(beanNames.operationSourceBeanName);
        if (!beanNames.factoryBeanName.equals(cacheOperationSource.getFactoryBeanName())) {
            registry.removeBeanDefinition(beanNames.operationSourceBeanName);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
            builder.setFactoryMethodOnBean(beanNames.operationSourceBeanName, beanNames.factoryBeanName);
            builder.setRole(2);
            registry.registerBeanDefinition(beanNames.operationSourceBeanName, (BeanDefinition)builder.getBeanDefinition());
        }
        if (!beanNames.factoryBeanName.equals((cacheInterceptor = registry.getBeanDefinition(beanNames.interceptorBeanName)).getFactoryBeanName())) {
            registry.removeBeanDefinition(beanNames.interceptorBeanName);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
            builder.setFactoryMethodOnBean(beanNames.interceptorBeanName, beanNames.factoryBeanName);
            builder.setRole(2);
            builder.addConstructorArgReference(beanNames.operationSourceBeanName);
            registry.registerBeanDefinition(beanNames.interceptorBeanName, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    static {
        if (log.isDebugEnabled()) {
            log.debug("Instantiating EnhancedCachePostProcessor, wish everything goes well");
        }
    }

    static enum CacheMatchingBeanNames {
        CACHING("enhancedCachingConfiguration", "cacheOperationSource", "cacheInterceptor"),
        JCACHE("enhancedJCacheConfiguration", "jCacheOperationSource", "jCacheInterceptor");

        public final String factoryBeanName;
        public final String operationSourceBeanName;
        public final String interceptorBeanName;

        private CacheMatchingBeanNames(String factoryBeanName, String operationSourceBeanName, String interceptorBeanName) {
            this.factoryBeanName = factoryBeanName;
            this.operationSourceBeanName = operationSourceBeanName;
            this.interceptorBeanName = interceptorBeanName;
        }
    }
}

