/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.convert;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.converter.CaffeineEnhancedCacheConverter;
import io.github.ms100.cacheasmulti.cache.convert.converter.ConcurrentMapEnhancedCacheConverter;
import io.github.ms100.cacheasmulti.cache.convert.converter.EhcacheEnhancedCacheConverter;
import io.github.ms100.cacheasmulti.cache.convert.converter.EnhancedCacheConverter;
import io.github.ms100.cacheasmulti.cache.convert.converter.RedisEnhancedCacheConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.CachingConfigurationSelector;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class EnhancedCacheConversionService
extends GenericConversionService
implements EnhancedCacheConverter<Cache> {
    private static final Logger log = LoggerFactory.getLogger(EnhancedCacheConversionService.class);
    private static final String REDIS_CACHE_CLASS_NAME = "org.springframework.data.redis.cache.RedisCache";
    private static final String CONCURRENT_MAP_CACHE_CLASS_NAME = "org.springframework.cache.concurrent.ConcurrentMapCache";
    private static final String EHCACHE_CLASS_NAME = "net.sf.ehcache.Ehcache";
    private static final String CAFFEINE_CACHE_CLASS_NAME = "com.github.benmanes.caffeine.cache.Cache";

    public EnhancedCacheConversionService(Collection<EnhancedCacheConverter<?>> converters) {
        ClassLoader classLoader = CachingConfigurationSelector.class.getClassLoader();
        if (ClassUtils.isPresent((String)REDIS_CACHE_CLASS_NAME, (ClassLoader)classLoader)) {
            this.addConverter(new RedisEnhancedCacheConverter());
        }
        if (ClassUtils.isPresent((String)CONCURRENT_MAP_CACHE_CLASS_NAME, (ClassLoader)classLoader)) {
            this.addConverter(new ConcurrentMapEnhancedCacheConverter());
        }
        if (ClassUtils.isPresent((String)EHCACHE_CLASS_NAME, (ClassLoader)classLoader)) {
            this.addConverter(new EhcacheEnhancedCacheConverter());
        }
        if (ClassUtils.isPresent((String)CAFFEINE_CACHE_CLASS_NAME, (ClassLoader)classLoader)) {
            this.addConverter(new CaffeineEnhancedCacheConverter());
        }
        converters.forEach(arg_0 -> ((EnhancedCacheConversionService)this).addConverter(arg_0));
        if (log.isDebugEnabled()) {
            log.debug("Add EnhancedCacheConverter: [{}]", (Object)converters.stream().map(c -> c.getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
    }

    @NonNull
    public EnhancedCache convert(Cache source) {
        if (super.canConvert(source.getClass(), EnhancedCache.class)) {
            return (EnhancedCache)Objects.requireNonNull(super.convert((Object)source, EnhancedCache.class));
        }
        log.warn("Cache {} is converted by EnhancedCacheAdapter, it is recommended to declare a dedicated EnhancedCache and EnhancedCacheConverter class", (Object)source.getClass().getSimpleName());
        return new EnhancedCacheAdapter(source);
    }

    static class EnhancedCacheAdapter
    implements EnhancedCache {
        private final Cache cache;

        @Override
        public Map<Object, Cache.ValueWrapper> multiGet(Collection<?> keys) {
            HashMap map = CollectionUtils.newHashMap((int)keys.size());
            keys.forEach(k -> {
                Cache.ValueWrapper valueWrapper = this.cache.get(k);
                map.put(k, valueWrapper);
            });
            return map;
        }

        @Override
        public void multiPut(Map<?, ?> map) {
            map.forEach((arg_0, arg_1) -> ((Cache)this.cache).put(arg_0, arg_1));
        }

        @Override
        public void multiEvict(Collection<?> keys) {
            keys.forEach(arg_0 -> ((Cache)this.cache).evict(arg_0));
        }

        public EnhancedCacheAdapter(Cache cache) {
            this.cache = cache;
        }

        public String getName() {
            return this.cache.getName();
        }

        public Object getNativeCache() {
            return this.cache.getNativeCache();
        }

        public Cache.ValueWrapper get(Object key) {
            return this.cache.get(key);
        }

        public <T> T get(Object arg0, Class<T> arg1) {
            return (T)this.cache.get(arg0, arg1);
        }

        public <T> T get(Object key, Callable<T> valueLoader) {
            return (T)this.cache.get(key, valueLoader);
        }

        public void put(Object arg0, Object arg1) {
            this.cache.put(arg0, arg1);
        }

        public Cache.ValueWrapper putIfAbsent(Object arg0, Object arg1) {
            return this.cache.putIfAbsent(arg0, arg1);
        }

        public void evict(Object key) {
            this.cache.evict(key);
        }

        public boolean evictIfPresent(Object key) {
            return this.cache.evictIfPresent(key);
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean invalidate() {
            return this.cache.invalidate();
        }
    }
}

