/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.convert.converter;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.converter.EnhancedCacheConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.util.CollectionUtils;

public class CaffeineEnhancedCacheConverter
implements EnhancedCacheConverter<CaffeineCache> {
    public EnhancedCache convert(CaffeineCache source) {
        return new CaffeineEnhancedCache(source.getName(), (Cache<Object, Object>)source.getNativeCache(), source.isAllowNullValues());
    }

    public static class CaffeineEnhancedCache
    extends CaffeineCache
    implements EnhancedCache {
        public CaffeineEnhancedCache(String name, Cache<Object, Object> cache, boolean allowNullValues) {
            super(name, cache, allowNullValues);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public Map<Object, Cache.ValueWrapper> multiGet(Collection<?> keys) {
            Cache cache = this.getNativeCache();
            @NonNull @NonNull Map map = cache instanceof LoadingCache ? ((LoadingCache)cache).getAll(keys) : cache.getAllPresent(keys);
            HashMap newMap = CollectionUtils.newHashMap((int)keys.size());
            map.forEach((key, value) -> newMap.put(key, this.toValueWrapper(value)));
            return newMap;
        }

        @Override
        public void multiPut(Map<?, ?> map) {
            HashMap newMap = CollectionUtils.newHashMap((int)map.size());
            map.forEach((key, value) -> newMap.put(key, this.toStoreValue(value)));
            this.getNativeCache().putAll((Map)newMap);
        }

        @Override
        public void multiEvict(Collection<?> keys) {
            this.getNativeCache().invalidateAll(keys);
        }
    }
}

