/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.convert.converter;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.converter.EnhancedCacheConverter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.core.serializer.support.SerializationDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class ConcurrentMapEnhancedCacheConverter
implements EnhancedCacheConverter<ConcurrentMapCache> {
    private static final Field SERIALIZATION_FIELD;

    public EnhancedCache convert(ConcurrentMapCache source) {
        SerializationDelegate serialization = source.isStoreByValue() ? (SerializationDelegate)SERIALIZATION_FIELD.get(source) : null;
        return new ConcurrentMapEnhancedCache(source.getName(), source.getNativeCache(), source.isAllowNullValues(), serialization);
    }

    static {
        try {
            SERIALIZATION_FIELD = ConcurrentMapCache.class.getDeclaredField("serialization");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        SERIALIZATION_FIELD.setAccessible(true);
    }

    public static class ConcurrentMapEnhancedCache
    extends ConcurrentMapCache
    implements EnhancedCache {
        protected ConcurrentMapEnhancedCache(String name, ConcurrentMap<Object, Object> store, boolean allowNullValues, @Nullable SerializationDelegate serialization) {
            super(name, store, allowNullValues, serialization);
        }

        @Override
        public Map<Object, Cache.ValueWrapper> multiGet(Collection<?> keys) {
            HashMap map = CollectionUtils.newHashMap((int)keys.size());
            keys.forEach(key -> {
                Cache.ValueWrapper valueWrapper = this.get(key);
                map.put(key, valueWrapper);
            });
            return map;
        }

        @Override
        public void multiPut(Map<?, ?> map) {
            HashMap newMap = CollectionUtils.newHashMap((int)map.size());
            map.forEach((k, v) -> newMap.put(k, this.toStoreValue(v)));
            ConcurrentMap store = this.getNativeCache();
            store.putAll(map);
        }

        @Override
        public void multiEvict(Collection<?> keys) {
            keys.forEach(arg_0 -> ((ConcurrentMapEnhancedCache)this).evict(arg_0));
        }
    }
}

