/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.convert.converter;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.converter.EnhancedCacheConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class EhcacheEnhancedCacheConverter
implements EnhancedCacheConverter<EhCacheCache> {
    public EnhancedCache convert(EhCacheCache source) {
        return new EhcacheEnhancedCache(source.getNativeCache());
    }

    public static class EhcacheEnhancedCache
    extends EhCacheCache
    implements EnhancedCache {
        public EhcacheEnhancedCache(Ehcache ehcache) {
            super(ehcache);
        }

        @Override
        public Map<Object, Cache.ValueWrapper> multiGet(Collection<?> keys) {
            Map map = this.getNativeCache().getAll(keys);
            HashMap newMap = CollectionUtils.newHashMap((int)keys.size());
            map.forEach((key, value) -> newMap.put(key, this.toValueWrapper((Element)value)));
            return newMap;
        }

        @Override
        public void multiPut(Map<?, ?> map) {
            ArrayList elements = new ArrayList(map.size());
            map.forEach((key, value) -> elements.add(new Element(key, value)));
            this.getNativeCache().putAll(elements);
        }

        @Override
        public void multiEvict(Collection<?> keys) {
            this.getNativeCache().removeAll(keys);
        }

        @Nullable
        private Cache.ValueWrapper toValueWrapper(@Nullable Element element) {
            return element != null ? new SimpleValueWrapper(element.getObjectValue()) : null;
        }
    }
}

