/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.convert.converter;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.converter.EnhancedCacheConverter;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class RedisEnhancedCacheConverter
implements EnhancedCacheConverter<RedisCache> {
    public EnhancedCache convert(RedisCache source) {
        return new RedisEnhancedCache(source.getName(), source.getNativeCache(), source.getCacheConfiguration());
    }

    static class RedisEnhancedCache
    extends RedisCache
    implements EnhancedCache {
        private static final String CACHE_WRITER_CLASS = "org.springframework.data.redis.cache.DefaultRedisCacheWriter";
        private final Method executeMethod;

        protected RedisEnhancedCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
            super(name, cacheWriter, cacheConfig);
            Class<?> cacheWriterClass = this.getNativeCache().getClass();
            if (!CACHE_WRITER_CLASS.equals(cacheWriterClass.getName())) {
                throw new IllegalStateException("cacheWriterClass must be org.springframework.data.redis.cache.DefaultRedisCacheWriter");
            }
            this.executeMethod = cacheWriterClass.getDeclaredMethod("execute", String.class, Function.class);
            this.executeMethod.setAccessible(true);
        }

        @Override
        public Map<Object, Cache.ValueWrapper> multiGet(Collection<?> keys) {
            Object[] keyArr = keys.toArray(new Object[0]);
            byte[][] bytes = (byte[][])Arrays.stream(keyArr).map(this::createAndConvertCacheKey).toArray(x$0 -> new byte[x$0][]);
            List values = this.execute(connection -> connection.mGet(bytes));
            if (keyArr.length != values.size()) {
                throw new IllegalStateException();
            }
            HashMap map = CollectionUtils.newHashMap((int)keyArr.length);
            int length = keyArr.length;
            for (int i = 0; i < length; ++i) {
                byte[] value = (byte[])values.get(i);
                Cache.ValueWrapper valueWrapper = this.toValueWrapper(value == null ? null : this.deserializeCacheValue(value));
                map.put(keyArr[i], valueWrapper);
            }
            return map;
        }

        @Override
        public void multiPut(Map<?, ?> map) {
            Stream<Object> stream = map.entrySet().stream();
            if (!this.isAllowNullValues()) {
                stream = stream.filter(entry -> entry.getValue() != null);
            }
            Map<byte[], byte[]> collect = stream.collect(Collectors.toMap(entry -> this.createAndConvertCacheKey(entry.getKey()), entry -> {
                Object cacheValue = this.preProcessCacheValue(entry.getValue());
                assert (cacheValue != null);
                return this.serializeCacheValue(cacheValue);
            }));
            Duration ttl = this.getCacheConfiguration().getTtl();
            if (RedisEnhancedCache.shouldExpireWithin(ttl)) {
                this.execute(connection -> {
                    connection.openPipeline();
                    boolean pipelinedClosed = false;
                    try {
                        collect.forEach((key, value) -> connection.set(key, value, Expiration.from((long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.upsert()));
                        connection.closePipeline();
                        pipelinedClosed = true;
                    }
                    finally {
                        if (!pipelinedClosed) {
                            connection.closePipeline();
                        }
                    }
                    return "OK";
                });
            } else {
                this.execute(connection -> {
                    connection.mSet(collect);
                    return "OK";
                });
            }
        }

        @Override
        public void multiEvict(Collection<?> keys) {
            byte[][] bytes = (byte[][])keys.stream().map(this::createAndConvertCacheKey).toArray(x$0 -> new byte[x$0][]);
            this.execute(connection -> connection.del(bytes));
        }

        private byte[] createAndConvertCacheKey(Object key) {
            return this.serializeCacheKey(this.createCacheKey(key));
        }

        private static boolean shouldExpireWithin(@Nullable Duration ttl) {
            return ttl != null && !ttl.isZero() && !ttl.isNegative();
        }

        private <T> T execute(Function<RedisConnection, T> callback) {
            return (T)this.executeMethod.invoke((Object)this.getNativeCache(), this.getName(), callback);
        }
    }
}

