/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCacheAsMultiOperation {
    protected final CacheAsMultiParameterDetail parameterDetail;
    @Nullable
    protected final Function<Collection<?>, Collection<?>> cacheAsMultiArgCreator;
    @Nullable
    protected final ReturnTypeMaker returnTypeMaker;

    public AbstractCacheAsMultiOperation(Method method, CacheAsMultiParameterDetail parameterDetail) {
        this.parameterDetail = parameterDetail;
        this.cacheAsMultiArgCreator = AbstractCacheAsMultiOperation.initializeCacheAsMultiArgCreator(parameterDetail);
        this.returnTypeMaker = AbstractCacheAsMultiOperation.initializeReturnTypeMaker(method, parameterDetail);
        this.validateParameterDetail(method, parameterDetail);
    }

    protected void validateParameterDetail(Method method, CacheAsMultiParameterDetail parameterDetail) {
        boolean isAllowedCollection;
        Class<AbstractCollection> rawType = parameterDetail.getRawType();
        boolean bl = isAllowedCollection = Collection.class.isAssignableFrom(rawType) && (rawType.isAssignableFrom(ArrayList.class) || rawType.isAssignableFrom(HashSet.class));
        if (!isAllowedCollection) {
            throw new IllegalStateException("The @CacheAsMulti parameter should be assignable from ArrayList or HashSet, and assign to Collection on " + method);
        }
    }

    public int getCacheAsMultiParameterPosition() {
        return this.parameterDetail.getPosition();
    }

    public boolean isStrictNull() {
        return this.parameterDetail.isStrictNull();
    }

    public Collection<?> newCacheAsMultiArg(Collection<?> subCacheAsMultiArg) {
        assert (this.cacheAsMultiArgCreator != null);
        return this.cacheAsMultiArgCreator.apply(subCacheAsMultiArg);
    }

    public Map<?, ?> makeCacheMap(Collection<?> subCacheAsMultiArg, @Nullable Object invokeValues) {
        if (this.returnTypeMaker == null) {
            return null;
        }
        return this.returnTypeMaker.makeCacheMap(this.parameterDetail, subCacheAsMultiArg, invokeValues);
    }

    @Nullable
    public Object makeReturnObject(Collection<?> cacheAsMultiArg, Map<?, ?> argValueMap) {
        if (this.returnTypeMaker == null) {
            return null;
        }
        return this.returnTypeMaker.makeReturnObject(this.parameterDetail, cacheAsMultiArg, argValueMap);
    }

    @Nullable
    protected static Function<Collection<?>, Collection<?>> initializeCacheAsMultiArgCreator(CacheAsMultiParameterDetail parameterDetail) {
        Class<AbstractCollection> rawType = parameterDetail.getRawType();
        if (rawType.isAssignableFrom(ArrayList.class)) {
            return ArrayList::new;
        }
        if (rawType.isAssignableFrom(HashSet.class)) {
            return HashSet::new;
        }
        return null;
    }

    @Nullable
    protected static ReturnTypeMaker<?> initializeReturnTypeMaker(Method method, CacheAsMultiParameterDetail parameterDetail) {
        ResolvableType returnResolvableType = ResolvableType.forMethodReturnType((Method)method);
        Class returnType = returnResolvableType.toClass();
        if (Map.class.isAssignableFrom(returnType) && returnType.isAssignableFrom(HashMap.class)) {
            Class returnGeneric;
            ResolvableType parameterResolvableType = ResolvableType.forMethodParameter((Method)method, (int)parameterDetail.getPosition());
            Class parameterGeneric = parameterResolvableType.resolveGeneric(new int[0]);
            if (parameterGeneric != (returnGeneric = returnResolvableType.resolveGeneric(new int[0]))) {
                throw new IllegalStateException("The key type of map returned is not same as @CacheAsMulti annotation parameter generic type on " + method);
            }
            return MapReturnTypeMaker.getInstance();
        }
        if (List.class.isAssignableFrom(returnType) && returnType.isAssignableFrom(ArrayList.class)) {
            if (!List.class.isAssignableFrom(parameterDetail.getRawType()) || !parameterDetail.getRawType().isAssignableFrom(ArrayList.class)) {
                throw new IllegalStateException("The @CacheAsMulti parameter type must be List when the return type is List on " + method);
            }
            return ListReturnTypeMaker.getInstance();
        }
        return null;
    }

    private static class MapReturnTypeMaker
    implements ReturnTypeMaker<Map<?, ?>> {
        private static final ReturnTypeMaker<Map<?, ?>> instance = new MapReturnTypeMaker();

        private MapReturnTypeMaker() {
        }

        @Override
        public Map<?, ?> makeCacheMap(CacheAsMultiParameterDetail parameterDetail, Collection<?> subCacheAsMultiArg, @Nullable Map<?, ?> invokeValues) {
            if (CollectionUtils.isEmpty(invokeValues)) {
                if (parameterDetail.isStrictNull()) {
                    return Collections.emptyMap();
                }
                HashMap map = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
                for (Object o : subCacheAsMultiArg) {
                    map.put(o, null);
                }
                return map;
            }
            if (parameterDetail.isStrictNull() || invokeValues.size() == subCacheAsMultiArg.size()) {
                return invokeValues;
            }
            HashMap map = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
            for (Object o : subCacheAsMultiArg) {
                map.put(o, invokeValues.get(o));
            }
            return map;
        }

        @Override
        @Nullable
        public Map<?, ?> makeReturnObject(CacheAsMultiParameterDetail parameterDetail, Collection<?> cacheAsMultiArg, Map<?, ?> argValueMap) {
            if (!parameterDetail.isStrictNull()) {
                argValueMap.entrySet().removeIf(e -> e.getValue() == null);
            }
            return argValueMap;
        }

        public static ReturnTypeMaker<Map<?, ?>> getInstance() {
            return instance;
        }
    }

    private static class ListReturnTypeMaker
    implements ReturnTypeMaker<List<?>> {
        private static final SimpleEvaluationContext.Builder CONTEXT_BUILDER = SimpleEvaluationContext.forReadOnlyDataBinding();
        private static final ReturnTypeMaker<List<?>> instance = new ListReturnTypeMaker();

        private ListReturnTypeMaker() {
        }

        @Override
        public Map<?, ?> makeCacheMap(CacheAsMultiParameterDetail parameterDetail, Collection<?> subCacheAsMultiArg, @Nullable List<?> invokeValues) {
            if (CollectionUtils.isEmpty(invokeValues)) {
                if (parameterDetail.isStrictNull()) {
                    return Collections.emptyMap();
                }
                HashMap map = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
                for (Object o : subCacheAsMultiArg) {
                    map.put(o, null);
                }
                return map;
            }
            if (parameterDetail.getAsElementFieldExpression() == null) {
                if (invokeValues.size() != subCacheAsMultiArg.size()) {
                    throw new IllegalStateException("The size of return list is not equal to the size of parameter list");
                }
                HashMap map = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
                Iterator<?> iterator = invokeValues.iterator();
                subCacheAsMultiArg.forEach(argItem -> map.put(argItem, iterator.next()));
                return map;
            }
            HashMap map = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
            invokeValues.forEach(i -> {
                SimpleEvaluationContext context = CONTEXT_BUILDER.withRootObject(i).build();
                map.put(parameterDetail.getAsElementFieldExpression().getValue((EvaluationContext)context), i);
            });
            if (!parameterDetail.isStrictNull() && map.size() != subCacheAsMultiArg.size()) {
                subCacheAsMultiArg.forEach(argItem -> map.putIfAbsent(argItem, null));
            }
            return map;
        }

        @Override
        @Nullable
        public List<?> makeReturnObject(CacheAsMultiParameterDetail parameterDetail, Collection<?> cacheAsMultiArg, Map<?, ?> argValueMap) {
            ArrayList res = new ArrayList(cacheAsMultiArg.size());
            if (parameterDetail.getAsElementFieldExpression() == null || parameterDetail.isStrictNull()) {
                cacheAsMultiArg.forEach(argItem -> res.add(argValueMap.get(argItem)));
            } else {
                cacheAsMultiArg.forEach(argItem -> {
                    if (argValueMap.get(argItem) != null) {
                        res.add(argValueMap.get(argItem));
                    }
                });
            }
            return res;
        }

        public static ReturnTypeMaker<List<?>> getInstance() {
            return instance;
        }
    }

    private static interface ReturnTypeMaker<T> {
        public Map<?, ?> makeCacheMap(CacheAsMultiParameterDetail var1, Collection<?> var2, @Nullable T var3);

        @Nullable
        public T makeReturnObject(CacheAsMultiParameterDetail var1, Collection<?> var2, Map<?, ?> var3);
    }
}

