/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import io.github.ms100.cacheasmulti.cache.interceptor.AbstractCacheAsMultiOperation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.CompoundExpression;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.VariableReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

class CacheAsMultiOperation<O extends CacheOperation>
extends AbstractCacheAsMultiOperation {
    private static final Logger log = LoggerFactory.getLogger(CacheAsMultiOperation.class);
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    protected final O operation;

    public CacheAsMultiOperation(Method method, O operation, CacheAsMultiParameterDetail parameterDetail) {
        super(method, parameterDetail);
        this.operation = operation;
        CacheAsMultiOperation.validate(method, operation, parameterDetail);
        if (this.returnTypeMaker == null && !(operation instanceof CacheEvictOperation)) {
            throw new IllegalStateException("The returnType must not be null when operation is not instanceof CacheEvictOperation on " + method);
        }
    }

    private static void validate(Method method, CacheOperation operation, CacheAsMultiParameterDetail parameterDetail) {
        if (StringUtils.hasText((String)operation.getKey())) {
            boolean parameterInExpression;
            KeyExpressionParser keyExpressionParser = new KeyExpressionParser(operation.getKey());
            String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method);
            Objects.requireNonNull(parameterNames);
            int parameterPosition = parameterDetail.getPosition();
            boolean bl = parameterInExpression = keyExpressionParser.containParameter(parameterPosition) || keyExpressionParser.containParameter(parameterNames[parameterPosition]);
            if (!parameterInExpression && (operation instanceof CachePutOperation || operation instanceof CacheEvictOperation)) {
                parameterInExpression = keyExpressionParser.containParameter("result");
            }
            if (!parameterInExpression) {
                throw new IllegalStateException("The @CacheAsMulti parameter or result should be in key expression on " + method);
            }
        }
    }

    public O getOperation() {
        return this.operation;
    }

    protected static class KeyExpressionParser {
        private final Set<Integer> indexSet = new HashSet<Integer>();
        private final Set<String> nameSet = new HashSet<String>();
        private static final SpelExpressionParser PARSER = new SpelExpressionParser();
        private static final Pattern PATTERN_ARG_INDEX = Pattern.compile("^#(?:a|p)(\\d+)$");
        public static final String ROOT_VARIABLE = "#root";
        public static final String ARGS_VARIABLE = "args";

        public KeyExpressionParser(String keyExpression) {
            SpelExpression expression = (SpelExpression)PARSER.parseExpression(keyExpression);
            SpelNode ast = expression.getAST();
            this.scanNode(ast);
        }

        public boolean containParameter(String name) {
            return this.nameSet.contains(name);
        }

        public boolean containParameter(int position) {
            return this.indexSet.contains(position);
        }

        private void scanNode(SpelNode node) {
            if (node instanceof CompoundExpression) {
                SpelNode child0 = node.getChild(0);
                if (!(child0 instanceof VariableReference)) {
                    return;
                }
                String child0NodeName = child0.toStringAST();
                if (!ROOT_VARIABLE.equals(child0NodeName)) {
                    this.scanNode(child0);
                    return;
                }
                SpelNode child1 = node.getChild(1);
                if (!(child1 instanceof PropertyOrFieldReference) || !ARGS_VARIABLE.equals(child1.toStringAST())) {
                    return;
                }
                SpelNode child2 = node.getChild(2);
                if (!(child2 instanceof Indexer)) {
                    return;
                }
                Literal indexNode = (Literal)child2.getChild(0);
                String originalValue = indexNode.getOriginalValue();
                Objects.requireNonNull(originalValue);
                this.indexSet.add(Integer.valueOf(originalValue));
            } else if (node instanceof VariableReference) {
                String nodeName = node.toStringAST();
                if (ROOT_VARIABLE.equals(nodeName)) {
                    return;
                }
                Matcher m = PATTERN_ARG_INDEX.matcher(nodeName);
                if (m.matches()) {
                    this.indexSet.add(Integer.valueOf(m.group(1)));
                } else {
                    this.nameSet.add(nodeName.substring(1));
                }
            } else {
                int childCount = node.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    this.scanNode(node.getChild(i));
                }
            }
        }
    }
}

