/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.EnhancedCacheConversionService;
import io.github.ms100.cacheasmulti.cache.interceptor.CacheAsMultiOperation;
import io.github.ms100.cacheasmulti.cache.interceptor.CacheAsMultiOperationInvoker;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCacheResolver;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCachingOperationSource;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCachingResolverAdapter;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.expression.EvaluationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class EnhancedCachingInterceptor
extends CacheInterceptor {
    private static final Logger log = LoggerFactory.getLogger(EnhancedCachingInterceptor.class);
    private final ConcurrentMap<CacheResolver, EnhancedCacheResolver> enhancedCacheResolverCache = new ConcurrentHashMap<CacheResolver, EnhancedCacheResolver>(1024);
    private static final Field CONTEXT_CONDITION_PASSING_FIELD = Objects.requireNonNull(ReflectionUtils.findField(CacheAsMultiOperationContext.class, (String)"conditionPassing"));

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Assert.state((boolean)(invocation instanceof ProxyMethodInvocation), (String)"Invocation must be ProxyMethodInvocation");
        CacheAsMultiOperationInvoker invoker = new CacheAsMultiOperationInvoker((ProxyMethodInvocation)invocation);
        Method method = invocation.getMethod();
        Object target = invocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            return this.execute(invoker, target, method, invocation.getArguments());
        }
        catch (CacheOperationInvoker.ThrowableWrapper th) {
            throw th.getOriginal();
        }
    }

    @Nullable
    protected Object execute(CacheOperationInvoker invoker, Object target, Method method, Object[] args) {
        Class targetClass;
        Collection<CacheAsMultiOperation<?>> multiOperations;
        EnhancedCachingOperationSource cacheOperationSource = (EnhancedCachingOperationSource)this.getCacheOperationSource();
        if (cacheOperationSource != null && !CollectionUtils.isEmpty(multiOperations = cacheOperationSource.getCacheAsMultiOperations(method, targetClass = AopProxyUtils.ultimateTargetClass((Object)target)))) {
            CacheAsMultiOperationContexts contexts = new CacheAsMultiOperationContexts(multiOperations, method, args, target, targetClass);
            return this.execute(invoker, contexts);
        }
        return super.execute(invoker, target, method, args);
    }

    @Nullable
    private Object execute(CacheOperationInvoker invoker, CacheAsMultiOperationContexts contexts) {
        Map<?, ?> argValueMap;
        Object returnValue;
        Collection<?> cacheAsMultiArg;
        if (contexts.isSynchronized()) {
            try {
                return Objects.requireNonNull(this.findCachedItems(contexts, invoker)).getRight();
            }
            catch (Cache.ValueRetrievalException ex) {
                ReflectionUtils.rethrowRuntimeException((Throwable)ex.getCause());
            }
        }
        if (CollectionUtils.isEmpty(cacheAsMultiArg = contexts.getCacheAsMultiArg())) {
            return this.invokeOperation(invoker);
        }
        this.processCacheEvicts(contexts, true, null);
        if (this.hasCachePut(contexts)) {
            returnValue = this.invokeOperation(invoker);
            CacheAsMultiOperation<?> multiOperation = contexts.getFirst(CachePutOperation.class).getMultiOperation();
            argValueMap = multiOperation.makeCacheMap(cacheAsMultiArg, returnValue);
            if (!CollectionUtils.isEmpty(argValueMap)) {
                this.putCachedItems(contexts.get(CacheableOperation.class), argValueMap);
                this.putCachedItems(contexts.get(CachePutOperation.class), argValueMap);
            }
        } else {
            Pair<Map<?, ?>, Object> pair = this.findCachedItems(contexts, invoker);
            if (pair != null) {
                argValueMap = (Map<?, ?>)pair.getLeft();
                returnValue = pair.getRight();
            } else {
                returnValue = this.invokeOperation(invoker);
                CacheAsMultiOperation<?> multiOperation = contexts.getFirst(CacheEvictOperation.class).getMultiOperation();
                argValueMap = multiOperation.makeCacheMap(cacheAsMultiArg, returnValue);
            }
        }
        this.processCacheEvicts(contexts, false, argValueMap);
        return returnValue;
    }

    private void processCacheEvicts(CacheAsMultiOperationContexts contexts, boolean beforeInvocation, @Nullable Map<?, ?> argValueMap) {
        Collection<?> cacheAsMultiArg = contexts.getCacheAsMultiArg();
        assert (cacheAsMultiArg != null);
        Collection<CacheAsMultiOperationContext> cacheEvictContexts = contexts.get(CacheEvictOperation.class);
        for (CacheAsMultiOperationContext context : cacheEvictContexts) {
            Pair<Collection<?>, Collection<?>> pair;
            CacheEvictOperation operation = (CacheEvictOperation)context.getOperation();
            if (beforeInvocation != operation.isBeforeInvocation() || ((Collection)(pair = EnhancedCachingInterceptor.splitIsConditionPassing(context, cacheAsMultiArg, argValueMap)).getLeft()).isEmpty()) continue;
            this.performCacheEvict(context, operation, (Collection)pair.getLeft(), argValueMap);
        }
    }

    private void performCacheEvict(CacheAsMultiOperationContext context, CacheEvictOperation operation, Collection<?> subCacheAsMultiArg, @Nullable Map<?, ?> argValueMap) {
        Collection<Object> keys = null;
        for (EnhancedCache enhancedCache : context.getCaches()) {
            if (operation.isCacheWide()) {
                if (log.isTraceEnabled()) {
                    log.trace("Invalidating entire cache for operation " + operation);
                }
                this.doClear(enhancedCache, operation.isBeforeInvocation());
                continue;
            }
            if (keys == null) {
                keys = this.generateKeys(context, subCacheAsMultiArg, argValueMap);
                if (log.isTraceEnabled()) {
                    log.trace("Invalidating cache keys " + keys + " for operation " + operation);
                }
            }
            this.doMultiEvict(enhancedCache, keys);
        }
    }

    @Nullable
    private Pair<Map<?, ?>, Object> findCachedItems(CacheAsMultiOperationContexts contexts, CacheOperationInvoker invoker) {
        CacheAsMultiOperationContext context;
        Collection<CacheAsMultiOperationContext> cacheableContexts = contexts.get(CacheableOperation.class);
        if (cacheableContexts.isEmpty()) {
            return null;
        }
        CacheAsMultiOperationContext firstContext = cacheableContexts.iterator().next();
        CacheAsMultiOperation<?> multiOperation = firstContext.getMultiOperation();
        Collection<?> cacheAsMultiArg = contexts.getCacheAsMultiArg();
        assert (cacheAsMultiArg != null);
        HashMap argValueMap = CollectionUtils.newHashMap((int)cacheAsMultiArg.size());
        Collection<?> missCacheAsMultiArg = cacheAsMultiArg;
        Iterator<CacheAsMultiOperationContext> iterator = cacheableContexts.iterator();
        while (iterator.hasNext() && !(missCacheAsMultiArg = this.findInCaches(context = iterator.next(), missCacheAsMultiArg, argValueMap)).isEmpty()) {
        }
        if (log.isDebugEnabled()) {
            log.debug("Hit cache args " + argValueMap.keySet());
        }
        if (missCacheAsMultiArg.isEmpty()) {
            return Pair.of((Object)argValueMap, (Object)multiOperation.makeReturnObject(cacheAsMultiArg, argValueMap));
        }
        missCacheAsMultiArg = argValueMap.isEmpty() ? cacheAsMultiArg : multiOperation.newCacheAsMultiArg(missCacheAsMultiArg);
        if (log.isDebugEnabled()) {
            log.debug("Miss cache args " + missCacheAsMultiArg);
        }
        return this.invokeWithMissCacheAsMultiArg(cacheableContexts, invoker, missCacheAsMultiArg, argValueMap);
    }

    private Collection<?> findInCaches(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg, Map<Object, Object> argValueMap) {
        Pair<Collection<?>, Collection<?>> pair = EnhancedCachingInterceptor.splitIsConditionPassing(context, subCacheAsMultiArg, null);
        if (((Collection)pair.getLeft()).isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("No cache entry for cacheAsMulti '" + subCacheAsMultiArg + "' in cache(s) " + context.getCacheNames());
            }
            return subCacheAsMultiArg;
        }
        Map<Object, Object> argKeyMap = this.generateArgKeyMap(context, (Collection)pair.getLeft());
        if (log.isTraceEnabled()) {
            log.trace("Find keys " + argKeyMap.values() + " for operation " + context.getOperation());
        }
        ArrayList missCacheAsMultiArg = (ArrayList)pair.getLeft();
        ArrayList<Object> missKeys = new ArrayList<Object>(argKeyMap.values());
        for (EnhancedCache enhancedCache : context.getCaches()) {
            Map<Object, Cache.ValueWrapper> hitKeyValueWrapperMap = this.doMultiGet(enhancedCache, missKeys);
            if (CollectionUtils.isEmpty(hitKeyValueWrapperMap)) continue;
            missKeys.clear();
            ArrayList newMissCacheAsMultiArg = new ArrayList(missCacheAsMultiArg.size());
            missCacheAsMultiArg.forEach(argItem -> {
                Object key = argKeyMap.get(argItem);
                Cache.ValueWrapper valueWrapper = (Cache.ValueWrapper)hitKeyValueWrapperMap.get(key);
                if (valueWrapper != null) {
                    argValueMap.put(argItem, valueWrapper.get());
                } else {
                    newMissCacheAsMultiArg.add(argItem);
                    missKeys.add(key);
                }
            });
            missCacheAsMultiArg = newMissCacheAsMultiArg;
            if (log.isTraceEnabled()) {
                Set hitKeys = hitKeyValueWrapperMap.entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toSet());
                log.trace("Cache entry for key '" + hitKeys + "' found in cache '" + enhancedCache.getName() + "'");
            }
            if (!missCacheAsMultiArg.isEmpty()) continue;
            return (Collection)pair.getRight();
        }
        if (((Collection)pair.getRight()).isEmpty()) {
            return missCacheAsMultiArg;
        }
        ((Collection)pair.getRight()).addAll(missCacheAsMultiArg);
        return (Collection)pair.getRight();
    }

    private Pair<Map<?, ?>, Object> invokeWithMissCacheAsMultiArg(Collection<CacheAsMultiOperationContext> contexts, CacheOperationInvoker invoker, Collection<?> missCacheAsMultiArg, Map<Object, Object> argValueMap) {
        CacheAsMultiOperationContext firstContext = contexts.iterator().next();
        Object invokeValues = this.invokeOperation(firstContext, invoker, missCacheAsMultiArg);
        CacheAsMultiOperation<?> multiOperation = firstContext.getMultiOperation();
        Map<?, ?> missArgValueMap = multiOperation.makeCacheMap(missCacheAsMultiArg, invokeValues);
        if (!CollectionUtils.isEmpty(missArgValueMap)) {
            this.putCachedItems(contexts, missArgValueMap);
            if (argValueMap.size() == 0) {
                return Pair.of(missArgValueMap, (Object)invokeValues);
            }
            argValueMap.putAll(missArgValueMap);
        }
        return Pair.of(argValueMap, (Object)multiOperation.makeReturnObject(firstContext.getCacheAsMultiArg(), argValueMap));
    }

    private void putCachedItems(Collection<CacheAsMultiOperationContext> contexts, Map<?, ?> argValueMap) {
        for (CacheAsMultiOperationContext context : contexts) {
            Pair<Collection<?>, Collection<?>> pair = EnhancedCachingInterceptor.splitIsConditionPassing(context, argValueMap.keySet(), argValueMap);
            if (((Collection)pair.getLeft()).isEmpty() || ((Collection)(pair = EnhancedCachingInterceptor.splitCanPutToCache(context, (Collection)pair.getLeft(), argValueMap)).getLeft()).isEmpty()) continue;
            Map<Object, Object> keyValueMap = this.generateKeyValueMap(context, (Collection)pair.getLeft(), argValueMap);
            if (log.isTraceEnabled()) {
                log.trace("Store key-value map " + keyValueMap + " for operation " + context.getOperation());
            }
            for (EnhancedCache enhancedCache : context.getCaches()) {
                this.doMultiPut(enhancedCache, keyValueMap);
            }
        }
    }

    private boolean hasCachePut(CacheAsMultiOperationContexts contexts) {
        Collection<?> cacheAsMultiArg = contexts.getCacheAsMultiArg();
        assert (cacheAsMultiArg != null);
        Collection<CacheAsMultiOperationContext> cachePutContexts = contexts.get(CachePutOperation.class);
        for (CacheAsMultiOperationContext context : cachePutContexts) {
            try {
                Pair<Collection<?>, Collection<?>> pair = EnhancedCachingInterceptor.splitIsConditionPassing(context, cacheAsMultiArg, null);
                if (((Collection)pair.getLeft()).isEmpty()) continue;
                return true;
            }
            catch (EvaluationException ex) {
                if (!"org.springframework.cache.interceptor.VariableNotAvailableException".equals(((Object)((Object)ex)).getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Object invokeOperation(CacheAsMultiOperationContext context, CacheOperationInvoker invoker, Object missCacheAsMultiArg) {
        Object[] invokeArg = context.getInvokeArg(missCacheAsMultiArg);
        return ((CacheAsMultiOperationInvoker)invoker).invoke(invokeArg);
    }

    private static Pair<Collection<?>, Collection<?>> splitIsConditionPassing(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg, @Nullable Map<?, ?> argValueMap) {
        Pair pair = context.splitIsConditionPassing(subCacheAsMultiArg, argValueMap);
        if (log.isTraceEnabled()) {
            log.trace("Cache condition allow:" + pair.getLeft() + ", deny:" + pair.getRight() + " for operation " + context.getOperation());
        }
        return pair;
    }

    private static Pair<Collection<?>, Collection<?>> splitCanPutToCache(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg, Map<?, ?> argValueMap) {
        Pair pair = context.splitCanPutToCache(subCacheAsMultiArg, argValueMap);
        if (log.isTraceEnabled()) {
            log.trace("Cache condition allow:" + pair.getLeft() + ", deny:" + pair.getRight() + " for operation " + context.getOperation());
        }
        return pair;
    }

    private Collection<Object> generateKeys(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg, @Nullable Map<?, ?> argValueMap) {
        if (argValueMap == null) {
            argValueMap = Collections.emptyMap();
        }
        ArrayList<Object> keys = new ArrayList<Object>(subCacheAsMultiArg.size());
        for (Object argItem : subCacheAsMultiArg) {
            keys.add(context.generateKey(argItem, argValueMap.get(argItem)));
        }
        return keys;
    }

    private Map<Object, Object> generateArgKeyMap(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg) {
        HashMap argKeyMap = CollectionUtils.newHashMap((int)subCacheAsMultiArg.size());
        for (Object argItem : subCacheAsMultiArg) {
            argKeyMap.put(argItem, context.generateKey(argItem, null));
        }
        return argKeyMap;
    }

    private Map<Object, Object> generateKeyValueMap(CacheAsMultiOperationContext context, Collection<?> subCacheAsMultiArg, Map<?, ?> argValueMap) {
        HashMap keyValueMap = CollectionUtils.newHashMap((int)argValueMap.size());
        for (Object argItem : subCacheAsMultiArg) {
            Object value = argValueMap.get(argItem);
            keyValueMap.put(context.generateKey(argItem, value), value);
        }
        return keyValueMap;
    }

    @Nullable
    protected Map<Object, Cache.ValueWrapper> doMultiGet(EnhancedCache cache, Collection<?> keys) {
        try {
            return cache.multiGet(keys);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheGetError(ex, (Cache)cache, keys);
            return null;
        }
    }

    protected void doMultiPut(EnhancedCache cache, Map<?, ?> map) {
        try {
            cache.multiPut(map);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCachePutError(ex, (Cache)cache, map.keySet(), map.values());
        }
    }

    protected void doMultiEvict(EnhancedCache cache, Collection<?> keys) {
        try {
            cache.multiEvict(keys);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheEvictError(ex, (Cache)cache, keys);
        }
    }

    protected CacheAsMultiOperationContext getMultiOperationContext(CacheAsMultiOperation<?> multiOperation, Method method, Object[] args, Object target, Class<?> targetClass) {
        CacheAspectSupport.CacheOperationMetadata metadata = this.getCacheOperationMetadata((CacheOperation)multiOperation.getOperation(), method, targetClass);
        return new CacheAsMultiOperationContext(multiOperation, metadata, args, target);
    }

    protected Collection<? extends Cache> getCaches(CacheOperationInvocationContext<CacheOperation> context, CacheResolver cacheResolver) {
        if (!(cacheResolver instanceof EnhancedCacheResolver)) {
            cacheResolver = this.enhancedCacheResolverCache.computeIfAbsent(cacheResolver, resolver -> new EnhancedCachingResolverAdapter((CacheResolver)resolver, (EnhancedCacheConversionService)this.getBean(Introspector.decapitalize(EnhancedCacheConversionService.class.getSimpleName()), EnhancedCacheConversionService.class)));
        }
        return super.getCaches(context, cacheResolver);
    }

    static {
        CONTEXT_CONDITION_PASSING_FIELD.setAccessible(true);
    }

    class CacheAsMultiOperationContext
    extends CacheAspectSupport.CacheOperationContext
    implements CacheOperationInvocationContext<CacheOperation> {
        private final CacheAsMultiOperation<?> multiOperation;
        private final Object[] superArgs;
        private final Collection<?> cacheAsMultiArg;
        @Nullable
        private Boolean isConditionAllPassing;
        private final Map<Object, Boolean> isConditionPassingCache;
        private final Map<Object, Object> keyCache;

        public CacheAsMultiOperationContext(CacheAsMultiOperation<?> multiOperation, CacheAspectSupport.CacheOperationMetadata metadata, Object[] args, Object target) {
            super((CacheAspectSupport)EnhancedCachingInterceptor.this, metadata, args, target);
            this.multiOperation = multiOperation;
            this.superArgs = super.getArgs();
            this.cacheAsMultiArg = (Collection)args[multiOperation.getCacheAsMultiParameterPosition()];
            this.isConditionPassingCache = CollectionUtils.newHashMap((int)this.cacheAsMultiArg.size());
            this.keyCache = CollectionUtils.newHashMap((int)this.cacheAsMultiArg.size());
        }

        protected Collection<String> getCacheNames() {
            return super.getCacheNames();
        }

        protected Collection<? extends EnhancedCache> getCaches() {
            return super.getCaches();
        }

        protected boolean isConditionPassing(Object cacheAsMultiArgItem, @Nullable Object result) {
            return this.isConditionPassingCache.computeIfAbsent(cacheAsMultiArgItem, argItem -> {
                this.superArgs[this.multiOperation.getCacheAsMultiParameterPosition()] = cacheAsMultiArgItem;
                boolean passing = super.isConditionPassing(result);
                try {
                    CONTEXT_CONDITION_PASSING_FIELD.set((Object)this, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                return passing;
            });
        }

        protected boolean canPutToCache(Object cacheAsMultiArgItem, @Nullable Object result) {
            this.superArgs[this.multiOperation.getCacheAsMultiParameterPosition()] = cacheAsMultiArgItem;
            return super.canPutToCache(result);
        }

        private Pair<Collection<?>, Collection<?>> splitIsConditionPassing(Collection<?> subCacheAsMultiArg, @Nullable Map<?, ?> argValueMap) {
            if (this.isConditionAllPassing == null && !StringUtils.hasText((String)this.getOperation().getCondition())) {
                this.isConditionAllPassing = true;
            }
            if (this.isConditionAllPassing.booleanValue()) {
                return Pair.of(subCacheAsMultiArg, Collections.emptyList());
            }
            if (argValueMap == null) {
                argValueMap = Collections.emptyMap();
            }
            return this.splitPassing(subCacheAsMultiArg, argValueMap, (ToBooleanBiFunction<Object, Object>)((ToBooleanBiFunction)this::isConditionPassing));
        }

        private Pair<Collection<?>, Collection<?>> splitCanPutToCache(Collection<?> subCacheAsMultiArg, Map<?, ?> argValueMap) {
            String unless = "";
            CacheOperation operation = this.getOperation();
            if (operation instanceof CacheableOperation) {
                unless = ((CacheableOperation)operation).getUnless();
            } else if (operation instanceof CachePutOperation) {
                unless = ((CachePutOperation)operation).getUnless();
            }
            if (!StringUtils.hasText((String)unless)) {
                return Pair.of(subCacheAsMultiArg, Collections.emptyList());
            }
            return this.splitPassing(subCacheAsMultiArg, argValueMap, (ToBooleanBiFunction<Object, Object>)((ToBooleanBiFunction)this::canPutToCache));
        }

        private Pair<Collection<?>, Collection<?>> splitPassing(Collection<?> subCacheAsMultiArg, Map<?, ?> argValueMap, ToBooleanBiFunction<Object, Object> function) {
            ArrayList allow = new ArrayList(subCacheAsMultiArg.size());
            ArrayList deny = new ArrayList(subCacheAsMultiArg.size());
            for (Object argItem : subCacheAsMultiArg) {
                boolean passing = function.applyAsBoolean(argItem, argValueMap.get(argItem));
                if (passing) {
                    allow.add(argItem);
                    continue;
                }
                deny.add(argItem);
            }
            return Pair.of(allow, deny);
        }

        protected Object generateKey(Object cacheAsMultiArgItem, @Nullable Object result) {
            return this.keyCache.computeIfAbsent(cacheAsMultiArgItem, argItem -> {
                this.superArgs[this.multiOperation.getCacheAsMultiParameterPosition()] = cacheAsMultiArgItem;
                Object key = super.generateKey(result);
                if (key == null) {
                    throw new IllegalArgumentException("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + super.getOperation());
                }
                return key;
            });
        }

        public Object[] getInvokeArg(Object subCacheAsMultiArg) {
            Object[] invokeArgs = (Object[])this.superArgs.clone();
            invokeArgs[this.multiOperation.getCacheAsMultiParameterPosition()] = subCacheAsMultiArg;
            return invokeArgs;
        }

        public CacheAsMultiOperation<?> getMultiOperation() {
            return this.multiOperation;
        }

        public Collection<?> getCacheAsMultiArg() {
            return this.cacheAsMultiArg;
        }
    }

    class CacheAsMultiOperationContexts {
        private final MultiValueMap<Class<? extends CacheOperation>, CacheAsMultiOperationContext> contexts;
        private final boolean sync;
        @Nullable
        private final Collection<?> cacheAsMultiArg;

        public CacheAsMultiOperationContexts(Collection<? extends CacheAsMultiOperation<?>> multiOperations, Method method, Object[] args, Object target, Class<?> targetClass) {
            Object[] argsClone = (Object[])args.clone();
            this.contexts = new LinkedMultiValueMap(multiOperations.size());
            for (CacheAsMultiOperation<?> multiOperation : multiOperations) {
                this.contexts.add(multiOperation.getOperation().getClass(), (Object)EnhancedCachingInterceptor.this.getMultiOperationContext(multiOperation, method, argsClone, target, targetClass));
            }
            int cacheAsMultiParameterPosition = multiOperations.iterator().next().getCacheAsMultiParameterPosition();
            this.cacheAsMultiArg = (Collection)args[cacheAsMultiParameterPosition];
            this.sync = this.determineSyncFlag(method);
        }

        public Collection<CacheAsMultiOperationContext> get(Class<? extends CacheOperation> operationClass) {
            List<CacheAsMultiOperationContext> result = (List<CacheAsMultiOperationContext>)this.contexts.get(operationClass);
            return result != null ? result : Collections.emptyList();
        }

        public CacheAsMultiOperationContext getFirst(Class<? extends CacheOperation> operationClass) {
            return (CacheAsMultiOperationContext)((Object)Objects.requireNonNull(this.contexts.getFirst(operationClass)));
        }

        public boolean isSynchronized() {
            return this.sync;
        }

        private boolean determineSyncFlag(Method method) {
            List cacheOperationContexts = (List)this.contexts.get(CacheableOperation.class);
            if (cacheOperationContexts == null) {
                return false;
            }
            boolean syncEnabled = false;
            for (CacheAsMultiOperationContext cacheOperationContext : cacheOperationContexts) {
                if (!((CacheableOperation)cacheOperationContext.getOperation()).isSync()) continue;
                syncEnabled = true;
                break;
            }
            if (syncEnabled) {
                if (this.contexts.size() > 1) {
                    throw new IllegalStateException("@Cacheable(sync=true) cannot be combined with other cache operations on '" + method + "'");
                }
                if (cacheOperationContexts.size() > 1) {
                    throw new IllegalStateException("Only one @Cacheable(sync=true) entry is allowed on '" + method + "'");
                }
                CacheAsMultiOperationContext cacheOperationContext = (CacheAsMultiOperationContext)((Object)cacheOperationContexts.iterator().next());
                CacheableOperation operation = (CacheableOperation)cacheOperationContext.getOperation();
                if (cacheOperationContext.getCaches().size() > 1) {
                    throw new IllegalStateException("@Cacheable(sync=true) only allows a single cache on '" + operation + "'");
                }
                if (StringUtils.hasText((String)operation.getUnless())) {
                    throw new IllegalStateException("@Cacheable(sync=true) does not support unless attribute on '" + operation + "'");
                }
                return true;
            }
            return false;
        }

        @Nullable
        public Collection<?> getCacheAsMultiArg() {
            return this.cacheAsMultiArg;
        }
    }
}

