/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiAnnotationUtils;
import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import io.github.ms100.cacheasmulti.cache.interceptor.CacheAsMultiOperation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class EnhancedCachingOperationSource
extends AnnotationCacheOperationSource {
    private final Map<Object, Collection<CacheAsMultiOperation<?>>> cacheAsMultiOperationsCache = new ConcurrentHashMap(1024);

    @Nullable
    public Collection<CacheAsMultiOperation<?>> getCacheAsMultiOperations(Method method, @Nullable Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        return this.cacheAsMultiOperationsCache.get(cacheKey);
    }

    @Nullable
    protected Collection<CacheOperation> findCacheOperations(Class<?> clazz) {
        return null;
    }

    @Nullable
    protected Collection<CacheOperation> findCacheOperations(Method method) {
        Collection cacheOperations = super.findCacheOperations(method);
        if (!(cacheOperations != null || (cacheOperations = super.findCacheOperations(method.getDeclaringClass())) != null && ClassUtils.isUserLevelMethod((Method)method))) {
            return null;
        }
        CacheAsMultiParameterDetail parameterDetail = this.findCacheAsMultiParameter(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        if (parameterDetail == null) {
            return cacheOperations;
        }
        ArrayList cacheAsMultiOperations = new ArrayList(cacheOperations.size());
        cacheOperations.forEach(cacheOperation -> {
            CacheAsMultiOperation<?> cacheAsMultiOperation = this.createCacheAsMultiOperation(method, (CacheOperation)cacheOperation, parameterDetail);
            cacheAsMultiOperations.add(cacheAsMultiOperation);
        });
        Object cacheKey = this.getCacheKey(method, method.getDeclaringClass());
        this.cacheAsMultiOperationsCache.put(cacheKey, cacheAsMultiOperations);
        return cacheOperations;
    }

    protected CacheAsMultiOperation<?> createCacheAsMultiOperation(Method method, CacheOperation cacheOperation, CacheAsMultiParameterDetail parameterDetail) {
        return new CacheAsMultiOperation<CacheOperation>(method, cacheOperation, parameterDetail);
    }

    @Nullable
    private CacheAsMultiParameterDetail findCacheAsMultiParameter(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Class<?> superclass;
        CacheAsMultiParameterDetail parameterDetail;
        Method method;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        if (method != null && (parameterDetail = CacheAsMultiAnnotationUtils.findAnnotation(method)) != null) {
            return parameterDetail;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interfaceClass : interfaces) {
                parameterDetail = this.findCacheAsMultiParameter(interfaceClass, methodName, parameterTypes);
                if (parameterDetail == null) continue;
                return parameterDetail;
            }
        }
        if ((superclass = clazz.getSuperclass()) != null && (parameterDetail = this.findCacheAsMultiParameter(superclass, methodName, parameterTypes)) != null) {
            return parameterDetail;
        }
        return null;
    }
}

