/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.cache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.convert.EnhancedCacheConversionService;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCacheResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;

public class EnhancedCachingResolverAdapter
implements EnhancedCacheResolver {
    private final ConcurrentMap<Cache, EnhancedCache> enhancedCacheCache = new ConcurrentHashMap<Cache, EnhancedCache>(1024);
    private final CacheResolver cacheResolver;
    private final EnhancedCacheConversionService conversionService;

    @Override
    public Collection<? extends EnhancedCache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection caches = this.cacheResolver.resolveCaches(context);
        if (caches.isEmpty()) {
            return Collections.emptyList();
        }
        return caches.stream().map(this::convert).collect(Collectors.toList());
    }

    private EnhancedCache convert(Cache cache) {
        return this.enhancedCacheCache.computeIfAbsent(cache, this.conversionService::convert);
    }

    public EnhancedCachingResolverAdapter(CacheResolver cacheResolver, EnhancedCacheConversionService conversionService) {
        this.cacheResolver = cacheResolver;
        this.conversionService = conversionService;
    }
}

