/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheAsMultiOperationContext;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.AbstractCacheInvoker;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

abstract class AbstractJCacheAsMultiInterceptor<O extends AbstractJCacheAsMultiOperation<A>, A extends Annotation>
extends AbstractCacheInvoker {
    private static final Logger log = LoggerFactory.getLogger(AbstractJCacheAsMultiInterceptor.class);

    public AbstractJCacheAsMultiInterceptor(CacheErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Nullable
    public abstract Object invoke(CacheAsMultiOperationContext<O, A> var1, CacheOperationInvoker var2);

    @Nullable
    protected Map<Object, Cache.ValueWrapper> doMultiGet(EnhancedCache cache, Collection<?> keys) {
        try {
            return cache.multiGet(keys);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheGetError(ex, (Cache)cache, keys);
            return null;
        }
    }

    protected void doMultiPut(EnhancedCache cache, Map<?, ?> map) {
        try {
            cache.multiPut(map);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCachePutError(ex, (Cache)cache, map.keySet(), map.values());
        }
    }

    protected void doMultiEvict(EnhancedCache cache, Collection<?> keys) {
        try {
            cache.multiEvict(keys);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheEvictError(ex, (Cache)cache, keys);
        }
    }

    protected EnhancedCache resolveCache(CacheAsMultiOperationContext<O, A> context) {
        JCacheOperation<A> operation = context.getOperation();
        Collection caches = operation.getCacheResolver().resolveCaches(context);
        Cache cache = AbstractJCacheAsMultiInterceptor.extractFrom(caches);
        if (cache == null) {
            throw new IllegalStateException("Cache could not have been resolved for " + operation);
        }
        return (EnhancedCache)cache;
    }

    @Nullable
    protected static Cache extractFrom(Collection<? extends Cache> caches) {
        if (CollectionUtils.isEmpty(caches)) {
            return null;
        }
        if (caches.size() == 1) {
            return caches.iterator().next();
        }
        throw new IllegalStateException("Unsupported cache resolution result " + caches + ": JSR-107 only supports a single cache.");
    }
}

