/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import io.github.ms100.cacheasmulti.cache.interceptor.AbstractCacheAsMultiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import javax.cache.annotation.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.util.ExceptionTypeFilter;
import org.springframework.util.ReflectionUtils;

abstract class AbstractJCacheAsMultiOperation<A extends Annotation>
extends AbstractCacheAsMultiOperation {
    private static final Logger log = LoggerFactory.getLogger(AbstractJCacheAsMultiOperation.class);
    protected final JCacheOperation<A> operation;
    protected final KeyGenerator keyGenerator;

    public AbstractJCacheAsMultiOperation(JCacheOperation<A> operation, KeyGenerator keyGenerator, CacheAsMultiParameterDetail parameterDetail) {
        super(operation.getMethod(), parameterDetail);
        this.operation = operation;
        this.keyGenerator = keyGenerator;
        AbstractJCacheAsMultiOperation.validate(operation, parameterDetail);
    }

    protected static ExceptionTypeFilter initializeExceptionTypeFilter(Class<? extends Throwable>[] includes, Class<? extends Throwable>[] excludes) {
        return new ExceptionTypeFilter(Arrays.asList(includes), Arrays.asList(excludes), true);
    }

    private static void validate(JCacheOperation<?> operation, CacheAsMultiParameterDetail parameterDetail) {
        Method method = operation.getMethod();
        if (!parameterDetail.isAnnotationPresent(CacheKey.class)) {
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(CacheKey.class)) continue;
                throw new IllegalStateException("The @CacheAsMulti parameter should has @CacheKey when other parameter has @CacheKey on " + method);
            }
        }
    }

    protected static Object getCacheOperationField(JCacheOperation<?> operation, String fieldName) {
        Class<?> operationClass = operation.getClass();
        Field field = ReflectionUtils.findField(operationClass, (String)fieldName);
        Objects.requireNonNull(field, "Invalid operation, not found " + fieldName + " on class " + operation.getClass().getName());
        field.setAccessible(true);
        return field.get(operation);
    }

    public JCacheOperation<A> getOperation() {
        return this.operation;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }
}

