/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.interceptor.AbstractCacheAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheInvocationParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

class CacheAsMultiOperationContext<O extends AbstractJCacheAsMultiOperation<A>, A extends Annotation>
implements CacheInvocationContext<A>,
CacheOperationInvocationContext<JCacheOperation<A>> {
    private static final Logger log = LoggerFactory.getLogger(CacheAsMultiOperationContext.class);
    private final O multiOperation;
    private final JCacheOperation<A> operation;
    private final Object target;
    private final Object[] args;
    @Nullable
    private final Object cacheAsMultiArg;
    private final CacheInvocationParameter[] allParameters;
    private final Map<Object, Object> keyCache;

    public CacheAsMultiOperationContext(O multiOperation, Object target, Object[] args) {
        this.multiOperation = multiOperation;
        this.operation = ((AbstractJCacheAsMultiOperation)multiOperation).getOperation();
        this.target = target;
        this.args = (Object[])args.clone();
        this.cacheAsMultiArg = args[((AbstractCacheAsMultiOperation)multiOperation).getCacheAsMultiParameterPosition()];
        this.allParameters = this.operation.getAllParameters(args);
        int size = 0;
        if (this.cacheAsMultiArg instanceof Collection) {
            size = ((Collection)this.cacheAsMultiArg).size();
        } else if (this.cacheAsMultiArg instanceof Map) {
            size = ((Map)this.cacheAsMultiArg).size();
        }
        this.keyCache = CollectionUtils.newHashMap((int)size);
    }

    public Method getMethod() {
        return this.operation.getMethod();
    }

    public <T> T unwrap(Class<T> cls) {
        throw new IllegalArgumentException("Cannot unwrap to " + cls);
    }

    public Set<Annotation> getAnnotations() {
        return this.operation.getAnnotations();
    }

    public A getCacheAnnotation() {
        return (A)this.operation.getCacheAnnotation();
    }

    public String getCacheName() {
        return this.operation.getCacheName();
    }

    public Object generateKey(Object cacheAsMultiArgItem) {
        return this.keyCache.computeIfAbsent(cacheAsMultiArgItem, argItem -> {
            this.args[((AbstractCacheAsMultiOperation)this.multiOperation).getCacheAsMultiParameterPosition()] = argItem;
            return ((AbstractJCacheAsMultiOperation)this.multiOperation).getKeyGenerator().generate(this.target, this.operation.getMethod(), this.args);
        });
    }

    public Object[] getInvokeArg(Object subCacheAsMultiArg) {
        Object[] invokeArgs = (Object[])this.args.clone();
        invokeArgs[((AbstractCacheAsMultiOperation)this.multiOperation).getCacheAsMultiParameterPosition()] = subCacheAsMultiArg;
        return invokeArgs;
    }

    public O getMultiOperation() {
        return this.multiOperation;
    }

    public JCacheOperation<A> getOperation() {
        return this.operation;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Nullable
    public Object getCacheAsMultiArg() {
        return this.cacheAsMultiArg;
    }

    public CacheInvocationParameter[] getAllParameters() {
        return this.allParameters;
    }

    public Map<Object, Object> getKeyCache() {
        return this.keyCache;
    }
}

