/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheAsMultiOperationContext;
import io.github.ms100.cacheasmulti.jcache.interceptor.CachePutAsMultiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.cache.annotation.CachePut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.util.CollectionUtils;

class CachePutAsMultiInterceptor
extends AbstractJCacheAsMultiInterceptor<CachePutAsMultiOperation, CachePut> {
    private static final Logger log = LoggerFactory.getLogger(CachePutAsMultiInterceptor.class);

    public CachePutAsMultiInterceptor(CacheErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    public Object invoke(CacheAsMultiOperationContext<CachePutAsMultiOperation, CachePut> context, CacheOperationInvoker invoker) {
        CachePutAsMultiOperation multiOperation = context.getMultiOperation();
        boolean earlyPut = multiOperation.isEarlyPut();
        if (earlyPut) {
            this.cacheValues(context);
        }
        try {
            Object result = invoker.invoke();
            if (!earlyPut) {
                this.cacheValues(context);
            }
            return result;
        }
        catch (CacheOperationInvoker.ThrowableWrapper ex) {
            Throwable original = ex.getOriginal();
            if (!earlyPut && multiOperation.getExceptionTypeFilter().match(original.getClass())) {
                this.cacheValues(context);
            }
            throw ex;
        }
    }

    protected void cacheValues(CacheAsMultiOperationContext<CachePutAsMultiOperation, CachePut> context) {
        Map cacheAsMultiArg = (Map)context.getCacheAsMultiArg();
        if (CollectionUtils.isEmpty((Map)cacheAsMultiArg)) {
            return;
        }
        HashMap keyValueMap = CollectionUtils.newHashMap((int)cacheAsMultiArg.size());
        cacheAsMultiArg.forEach((argItem, value) -> keyValueMap.put(context.generateKey(argItem), value));
        EnhancedCache cache = this.resolveCache(context);
        if (log.isTraceEnabled()) {
            log.trace("Store key-value map " + keyValueMap + " for operation " + context.getOperation());
        }
        this.doMultiPut(cache, keyValueMap);
    }
}

