/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiOperation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.util.ExceptionTypeFilter;

class CachePutAsMultiOperation
extends AbstractJCacheAsMultiOperation<CachePut> {
    private static final Logger log = LoggerFactory.getLogger(CachePutAsMultiOperation.class);
    private final ExceptionTypeFilter exceptionTypeFilter;

    public CachePutAsMultiOperation(JCacheOperation<CachePut> operation, KeyGenerator keyGenerator, CacheAsMultiParameterDetail parameterDetail) {
        super(operation, keyGenerator, parameterDetail);
        CachePut ann = (CachePut)operation.getCacheAnnotation();
        this.exceptionTypeFilter = CachePutAsMultiOperation.initializeExceptionTypeFilter(ann.cacheFor(), ann.noCacheFor());
        CachePutAsMultiOperation.initializeCachePutOperationKeyParameterDetails(operation, this.parameterDetail);
    }

    @Override
    protected void validateParameterDetail(Method method, CacheAsMultiParameterDetail parameterDetail) {
        if (!parameterDetail.isAnnotationPresent(CacheValue.class)) {
            throw new IllegalStateException("The @CacheAsMulti parameter should be same as @CacheValue on " + method);
        }
        Class<?> rawType = parameterDetail.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            throw new IllegalStateException("The @CacheAsMulti parameter should be a map on " + method);
        }
    }

    public boolean isEarlyPut() {
        return !((CachePut)this.operation.getCacheAnnotation()).afterInvocation();
    }

    private static void initializeCachePutOperationKeyParameterDetails(JCacheOperation<?> operation, CacheAsMultiParameterDetail parameterDetail) {
        if (parameterDetail.isAnnotationPresent(CacheKey.class)) {
            return;
        }
        List keyParameterList = (List)CachePutAsMultiOperation.getCacheOperationField(operation, "keyParameterDetails");
        Objects.requireNonNull(keyParameterList);
        List allParameterList = (List)CachePutAsMultiOperation.getCacheOperationField(operation, "allParameterDetails");
        Objects.requireNonNull(allParameterList);
        keyParameterList.clear();
        keyParameterList.addAll(allParameterList);
    }

    public ExceptionTypeFilter getExceptionTypeFilter() {
        return this.exceptionTypeFilter;
    }
}

