/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheAsMultiOperationContext;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheRemoveAsMultiOperation;
import java.util.ArrayList;
import java.util.Collection;
import javax.cache.annotation.CacheRemove;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.util.CollectionUtils;

class CacheRemoveAsMultiInterceptor
extends AbstractJCacheAsMultiInterceptor<CacheRemoveAsMultiOperation, CacheRemove> {
    private static final Logger log = LoggerFactory.getLogger(CacheRemoveAsMultiInterceptor.class);

    public CacheRemoveAsMultiInterceptor(CacheErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    public Object invoke(CacheAsMultiOperationContext<CacheRemoveAsMultiOperation, CacheRemove> context, CacheOperationInvoker invoker) {
        CacheRemoveAsMultiOperation multiOperation = context.getMultiOperation();
        boolean earlyRemove = multiOperation.isEarlyRemove();
        if (earlyRemove) {
            this.removeValues(context);
        }
        try {
            Object result = invoker.invoke();
            if (!earlyRemove) {
                this.removeValues(context);
            }
            return result;
        }
        catch (CacheOperationInvoker.ThrowableWrapper wrapperException) {
            Throwable ex = wrapperException.getOriginal();
            if (!earlyRemove && multiOperation.getExceptionTypeFilter().match(ex.getClass())) {
                this.removeValues(context);
            }
            throw wrapperException;
        }
    }

    private void removeValues(CacheAsMultiOperationContext<CacheRemoveAsMultiOperation, CacheRemove> context) {
        Collection cacheAsMultiArg = (Collection)context.getCacheAsMultiArg();
        if (CollectionUtils.isEmpty((Collection)cacheAsMultiArg)) {
            return;
        }
        ArrayList keys = new ArrayList(cacheAsMultiArg.size());
        cacheAsMultiArg.forEach(argItem -> keys.add(context.generateKey(argItem)));
        EnhancedCache cache = this.resolveCache(context);
        if (log.isTraceEnabled()) {
            log.trace("Evict keys " + keys + " for operation " + context.getOperation());
        }
        this.doMultiEvict(cache, keys);
    }
}

