/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.interceptor.CacheAsMultiOperationInvoker;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheAsMultiOperationContext;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheResultAsMultiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cache.annotation.CacheResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

class CacheResultAsMultiInterceptor
extends AbstractJCacheAsMultiInterceptor<CacheResultAsMultiOperation, CacheResult> {
    private static final Logger log = LoggerFactory.getLogger(CacheResultAsMultiInterceptor.class);

    public CacheResultAsMultiInterceptor(CacheErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    @Nullable
    public Object invoke(CacheAsMultiOperationContext<CacheResultAsMultiOperation, CacheResult> context, CacheOperationInvoker invoker) {
        Collection cacheAsMultiArg = (Collection)context.getCacheAsMultiArg();
        if (CollectionUtils.isEmpty((Collection)cacheAsMultiArg)) {
            return invoker.invoke();
        }
        HashMap argValueMap = CollectionUtils.newHashMap((int)cacheAsMultiArg.size());
        Collection<?> missCacheAsMultiArg = this.findInCache(context, cacheAsMultiArg, argValueMap);
        if (log.isDebugEnabled()) {
            log.debug("Hit cache args " + argValueMap.keySet());
        }
        if (missCacheAsMultiArg.isEmpty()) {
            CacheResultAsMultiOperation multiOperation = context.getMultiOperation();
            return multiOperation.makeReturnObject(cacheAsMultiArg, argValueMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("Miss cache args " + missCacheAsMultiArg);
        }
        return this.invokeWithMissCacheAsMultiArg(context, invoker, missCacheAsMultiArg, argValueMap);
    }

    private Collection<?> findInCache(CacheAsMultiOperationContext<CacheResultAsMultiOperation, CacheResult> context, Collection<?> cacheAsMultiArg, Map<Object, Object> argValueMap) {
        Collection<?> missCacheAsMultiArg;
        Map<Object, Cache.ValueWrapper> hitKeyValueWrapperMap;
        CacheResultAsMultiOperation multiOperation;
        HashMap argKeyMap = CollectionUtils.newHashMap((int)cacheAsMultiArg.size());
        cacheAsMultiArg.forEach(argItem -> argKeyMap.put(argItem, context.generateKey(argItem)));
        if (log.isTraceEnabled()) {
            log.trace("Find keys " + argKeyMap.values() + " for operation " + context.getOperation());
        }
        if ((multiOperation = context.getMultiOperation()).isAlwaysInvoked()) {
            hitKeyValueWrapperMap = null;
        } else {
            EnhancedCache cache = this.resolveCache(context);
            hitKeyValueWrapperMap = this.doMultiGet(cache, argKeyMap.values());
        }
        if (CollectionUtils.isEmpty(hitKeyValueWrapperMap)) {
            missCacheAsMultiArg = cacheAsMultiArg;
        } else {
            ArrayList newMissCacheAsMultiArg = new ArrayList(cacheAsMultiArg.size());
            argKeyMap.forEach((argItem, key) -> {
                Cache.ValueWrapper valueWrapper = (Cache.ValueWrapper)hitKeyValueWrapperMap.get(key);
                if (valueWrapper != null) {
                    argValueMap.put(argItem, valueWrapper.get());
                } else {
                    newMissCacheAsMultiArg.add(argItem);
                }
            });
            missCacheAsMultiArg = multiOperation.newCacheAsMultiArg(newMissCacheAsMultiArg);
        }
        return missCacheAsMultiArg;
    }

    @Nullable
    private Object invokeWithMissCacheAsMultiArg(CacheAsMultiOperationContext<CacheResultAsMultiOperation, CacheResult> context, CacheOperationInvoker invoker, Collection<?> missCacheAsMultiArg, Map<Object, Object> argValueMap) {
        this.checkForCachedException(context, missCacheAsMultiArg);
        Object invokeValues = this.invokeOperation(context, invoker, missCacheAsMultiArg);
        CacheResultAsMultiOperation multiOperation = context.getMultiOperation();
        Map<?, ?> missArgValueMap = multiOperation.makeCacheMap(missCacheAsMultiArg, invokeValues);
        if (!CollectionUtils.isEmpty(missArgValueMap)) {
            HashMap missKeyValueMap = CollectionUtils.newHashMap((int)missCacheAsMultiArg.size());
            missArgValueMap.forEach((argItem, value) -> missKeyValueMap.put(context.generateKey(argItem), value));
            EnhancedCache cache = this.resolveCache(context);
            this.doMultiPut(cache, missKeyValueMap);
            if (argValueMap.size() == 0) {
                return invokeValues;
            }
            argValueMap.putAll(missArgValueMap);
        }
        Collection cacheAsMultiArg = (Collection)context.getCacheAsMultiArg();
        assert (cacheAsMultiArg != null);
        return multiOperation.makeReturnObject(cacheAsMultiArg, argValueMap);
    }

    protected void checkForCachedException(CacheAsMultiOperationContext<CacheResultAsMultiOperation, ?> context, Collection<?> missCacheAsMultiArg) {
        EnhancedCache exceptionCache = this.resolveExceptionCache(context);
        if (exceptionCache != null) {
            Object ex;
            Collection missKeys = missCacheAsMultiArg.stream().map(context::generateKey).collect(Collectors.toList());
            Map<Object, Cache.ValueWrapper> keyThrowableWrapperMap = this.doMultiGet(exceptionCache, missKeys);
            if (keyThrowableWrapperMap != null && keyThrowableWrapperMap.size() != 0 && (ex = keyThrowableWrapperMap.values().stream().filter(Objects::nonNull).findFirst().orElse(() -> null).get()) instanceof Throwable) {
                throw new RuntimeException((Throwable)ex);
            }
        }
    }

    @Nullable
    private EnhancedCache resolveExceptionCache(CacheAsMultiOperationContext<CacheResultAsMultiOperation, ?> context) {
        CacheResultAsMultiOperation operation = context.getMultiOperation();
        CacheResolver exceptionCacheResolver = operation.getExceptionCacheResolver();
        if (exceptionCacheResolver != null) {
            return (EnhancedCache)CacheResultAsMultiInterceptor.extractFrom(exceptionCacheResolver.resolveCaches(context));
        }
        return null;
    }

    @Nullable
    private Object invokeOperation(CacheAsMultiOperationContext<?, ?> context, CacheOperationInvoker invoker, Object missCacheAsMultiArg) {
        Object[] invokeArg = context.getInvokeArg(missCacheAsMultiArg);
        return ((CacheAsMultiOperationInvoker)invoker).invoke(invokeArg);
    }
}

