/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.interceptor.CacheAsMultiOperationInvoker;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheAsMultiOperationContext;
import io.github.ms100.cacheasmulti.jcache.interceptor.CachePutAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CachePutAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheRemoveAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheRemoveAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheResultAsMultiInterceptor;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheResultAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.EnhancedJCacheOperationSource;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.jcache.interceptor.JCacheInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EnhancedJCacheInterceptor
extends JCacheInterceptor {
    @Nullable
    private CacheResultAsMultiInterceptor cacheResultMultiInterceptor;
    @Nullable
    private CachePutAsMultiInterceptor cachePutMultiInterceptor;
    @Nullable
    private CacheRemoveAsMultiInterceptor cacheRemoveMultiInterceptor;

    public EnhancedJCacheInterceptor(@Nullable Supplier<CacheErrorHandler> errorHandler) {
        super(errorHandler);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.cacheResultMultiInterceptor = new CacheResultAsMultiInterceptor(this.getErrorHandler());
        this.cachePutMultiInterceptor = new CachePutAsMultiInterceptor(this.getErrorHandler());
        this.cacheRemoveMultiInterceptor = new CacheRemoveAsMultiInterceptor(this.getErrorHandler());
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Assert.state((boolean)(invocation instanceof ProxyMethodInvocation), (String)"Invocation must be ProxyMethodInvocation");
        CacheAsMultiOperationInvoker invoker = new CacheAsMultiOperationInvoker((ProxyMethodInvocation)invocation);
        Method method = invocation.getMethod();
        Object target = invocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            return this.execute(invoker, target, method, invocation.getArguments());
        }
        catch (CacheOperationInvoker.ThrowableWrapper th) {
            throw th.getOriginal();
        }
    }

    @Nullable
    protected Object execute(CacheOperationInvoker invoker, Object target, Method method, Object[] args) {
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        AbstractJCacheAsMultiOperation<?> multiOperation = ((EnhancedJCacheOperationSource)this.getCacheOperationSource()).getCacheAsMultiOperation(method, targetClass);
        if (multiOperation != null) {
            CacheAsMultiOperationContext context = new CacheAsMultiOperationContext(multiOperation, target, args);
            return this.execute(context, invoker);
        }
        return super.execute(invoker, target, method, args);
    }

    @Nullable
    private Object execute(CacheAsMultiOperationContext<?, ?> context, CacheOperationInvoker invoker) {
        Object multiOperation = context.getMultiOperation();
        if (multiOperation instanceof CacheResultAsMultiOperation) {
            Assert.notNull((Object)((Object)this.cacheResultMultiInterceptor), (String)"No CacheResultMultiInterceptor");
            return this.cacheResultMultiInterceptor.invoke(context, (CacheOperationInvoker)((CacheAsMultiOperationInvoker)invoker));
        }
        if (multiOperation instanceof CachePutAsMultiOperation) {
            Assert.notNull((Object)((Object)this.cachePutMultiInterceptor), (String)"No CachePutMultiInterceptor");
            return this.cachePutMultiInterceptor.invoke((CacheAsMultiOperationContext<CachePutAsMultiOperation, CachePut>)context, invoker);
        }
        if (multiOperation instanceof CacheRemoveAsMultiOperation) {
            Assert.notNull((Object)((Object)this.cacheRemoveMultiInterceptor), (String)"No CacheRemoveMultiInterceptor");
            return this.cacheRemoveMultiInterceptor.invoke((CacheAsMultiOperationContext<CacheRemoveAsMultiOperation, CacheRemove>)context, invoker);
        }
        return null;
    }
}

