/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiAnnotationUtils;
import io.github.ms100.cacheasmulti.cache.annotation.CacheAsMultiParameterDetail;
import io.github.ms100.cacheasmulti.cache.convert.EnhancedCacheConversionService;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCachingResolverAdapter;
import io.github.ms100.cacheasmulti.jcache.interceptor.AbstractJCacheAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CachePutAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheRemoveAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.CacheResultAsMultiOperation;
import io.github.ms100.cacheasmulti.jcache.interceptor.EnhancedJCacheResolverAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.jcache.interceptor.DefaultJCacheOperationSource;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

public class EnhancedJCacheOperationSource
extends DefaultJCacheOperationSource {
    private final Map<Object, AbstractJCacheAsMultiOperation<?>> cacheAsMultiOperationCache = new ConcurrentHashMap(1024);
    private final SingletonSupplier<org.springframework.cache.interceptor.CacheResolver> adaptedCacheResolver = SingletonSupplier.of(() -> new EnhancedCachingResolverAdapter(super.getDefaultCacheResolver(), (EnhancedCacheConversionService)this.getBean(EnhancedCacheConversionService.class)));
    private final SingletonSupplier<org.springframework.cache.interceptor.CacheResolver> adaptedExceptionCacheResolver = SingletonSupplier.of(() -> new EnhancedCachingResolverAdapter(super.getDefaultExceptionCacheResolver(), (EnhancedCacheConversionService)this.getBean(EnhancedCacheConversionService.class)));

    public EnhancedJCacheOperationSource(@Nullable Supplier<CacheManager> cacheManager, @Nullable Supplier<org.springframework.cache.interceptor.CacheResolver> cacheResolver, @Nullable Supplier<org.springframework.cache.interceptor.CacheResolver> exceptionCacheResolver, @Nullable Supplier<KeyGenerator> keyGenerator) {
        super(cacheManager, cacheResolver, exceptionCacheResolver, keyGenerator);
    }

    @Nullable
    public AbstractJCacheAsMultiOperation<?> getCacheAsMultiOperation(Method method, @Nullable Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        return this.cacheAsMultiOperationCache.get(cacheKey);
    }

    protected JCacheOperation<?> findCacheOperation(Method method, @Nullable Class<?> targetClass) {
        JCacheOperation cacheOperation = super.findCacheOperation(method, targetClass);
        if (cacheOperation == null) {
            return null;
        }
        CacheAsMultiParameterDetail parameterDetail = CacheAsMultiAnnotationUtils.findAnnotation(method);
        if (parameterDetail == null) {
            return cacheOperation;
        }
        CacheDefaults defaults = this.getCacheDefaults(method, targetClass);
        AbstractJCacheAsMultiOperation<?> cacheAsMultiOperation = this.parseCacheAsMultiAnnotation(defaults, cacheOperation, parameterDetail);
        if (cacheAsMultiOperation != null) {
            Object cacheKey = this.getCacheKey(method, targetClass);
            this.cacheAsMultiOperationCache.put(cacheKey, cacheAsMultiOperation);
        }
        return cacheOperation;
    }

    @Nullable
    private AbstractJCacheAsMultiOperation<?> parseCacheAsMultiAnnotation(@Nullable CacheDefaults defaults, JCacheOperation<?> cacheOperation, CacheAsMultiParameterDetail parameterDetail) {
        Annotation cacheAnnotation = cacheOperation.getCacheAnnotation();
        if (cacheAnnotation instanceof CacheResult) {
            return this.createCacheResultMultiOperation(defaults, cacheOperation, parameterDetail);
        }
        if (cacheAnnotation instanceof CachePut) {
            return this.createCachePutMultiOperation(defaults, cacheOperation, parameterDetail);
        }
        if (cacheAnnotation instanceof CacheRemove) {
            return this.createCacheRemoveMultiOperation(defaults, cacheOperation, parameterDetail);
        }
        return null;
    }

    private Object getCacheKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    protected CacheResultAsMultiOperation createCacheResultMultiOperation(@Nullable CacheDefaults defaults, JCacheOperation<CacheResult> cacheOperation, CacheAsMultiParameterDetail parameterDetail) {
        CacheResult ann = (CacheResult)cacheOperation.getCacheAnnotation();
        KeyGenerator keyGenerator = this.determineKeyGenerator(defaults, ann.cacheKeyGenerator());
        CacheResolverFactory cacheResolverFactory = this.determineCacheResolverFactory(defaults, ann.cacheResolverFactory());
        org.springframework.cache.interceptor.CacheResolver exceptionCacheResolver = null;
        String exceptionCacheName = ann.exceptionCacheName();
        if (StringUtils.hasText((String)exceptionCacheName)) {
            exceptionCacheResolver = this.getExceptionCacheResolver(cacheResolverFactory, (CacheMethodDetails<CacheResult>)cacheOperation);
        }
        return new CacheResultAsMultiOperation(cacheOperation, keyGenerator, parameterDetail, exceptionCacheResolver);
    }

    protected CachePutAsMultiOperation createCachePutMultiOperation(@Nullable CacheDefaults defaults, JCacheOperation<CachePut> cacheOperation, CacheAsMultiParameterDetail parameterDetail) {
        CachePut ann = (CachePut)cacheOperation.getCacheAnnotation();
        KeyGenerator keyGenerator = this.determineKeyGenerator(defaults, ann.cacheKeyGenerator());
        return new CachePutAsMultiOperation(cacheOperation, keyGenerator, parameterDetail);
    }

    protected CacheRemoveAsMultiOperation createCacheRemoveMultiOperation(@Nullable CacheDefaults defaults, JCacheOperation<CacheRemove> cacheOperation, CacheAsMultiParameterDetail parameterDetail) {
        CacheRemove ann = (CacheRemove)cacheOperation.getCacheAnnotation();
        KeyGenerator keyGenerator = this.determineKeyGenerator(defaults, ann.cacheKeyGenerator());
        return new CacheRemoveAsMultiOperation(cacheOperation, keyGenerator, parameterDetail);
    }

    protected org.springframework.cache.interceptor.CacheResolver getCacheResolver(@Nullable CacheResolverFactory factory, CacheMethodDetails<?> details) {
        if (factory != null) {
            CacheResolver cacheResolver = factory.getCacheResolver(details);
            return new EnhancedJCacheResolverAdapter(cacheResolver);
        }
        return this.getDefaultCacheResolver();
    }

    protected org.springframework.cache.interceptor.CacheResolver getExceptionCacheResolver(@Nullable CacheResolverFactory factory, CacheMethodDetails<CacheResult> details) {
        if (factory != null) {
            CacheResolver cacheResolver = factory.getExceptionCacheResolver(details);
            return new EnhancedJCacheResolverAdapter(cacheResolver);
        }
        return this.getDefaultExceptionCacheResolver();
    }

    protected org.springframework.cache.interceptor.CacheResolver getDefaultCacheResolver() {
        return (org.springframework.cache.interceptor.CacheResolver)this.adaptedCacheResolver.obtain();
    }

    protected org.springframework.cache.interceptor.CacheResolver getDefaultExceptionCacheResolver() {
        return (org.springframework.cache.interceptor.CacheResolver)this.adaptedExceptionCacheResolver.obtain();
    }
}

