/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.jcache.interceptor;

import io.github.ms100.cacheasmulti.cache.EnhancedCache;
import io.github.ms100.cacheasmulti.cache.interceptor.EnhancedCacheResolver;
import io.github.ms100.cacheasmulti.jcache.EnhancedJCacheCache;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;

class EnhancedJCacheResolverAdapter
implements EnhancedCacheResolver {
    private final ConcurrentMap<Cache<Object, Object>, EnhancedCache> enhancedCacheCache = new ConcurrentHashMap<Cache<Object, Object>, EnhancedCache>(1024);
    private final CacheResolver cacheResolver;

    @Override
    public Collection<? extends EnhancedCache> resolveCaches(CacheOperationInvocationContext<?> context) {
        if (!(context instanceof CacheInvocationContext)) {
            throw new IllegalStateException("Unexpected context " + context);
        }
        CacheInvocationContext cacheInvocationContext = (CacheInvocationContext)context;
        Cache cache = this.cacheResolver.resolveCache(cacheInvocationContext);
        if (cache == null) {
            throw new IllegalStateException("Could not resolve cache for " + context + " using " + this.cacheResolver);
        }
        return Collections.singleton(this.convert((Cache<Object, Object>)cache));
    }

    private EnhancedCache convert(Cache<Object, Object> cache) {
        return this.enhancedCacheCache.computeIfAbsent(cache, EnhancedJCacheCache::new);
    }

    public EnhancedJCacheResolverAdapter(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }
}

