/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.core.MethodClassKey;

public class TypeMethodKeyGenerator
implements KeyGenerator {
    private final ConcurrentMap<Object, String> ptmCache = new ConcurrentHashMap<Object, String>(1024);
    private static final int GET_A_OFFSET = SimpleKey.class.getSimpleName().length() + 1;

    public Object generate(Object target, Method method, Object ... params) {
        Class<?> targetClass = target.getClass();
        Object ptmCacheKey = this.getCacheKey(method, targetClass);
        String prefix = this.ptmCache.computeIfAbsent(ptmCacheKey, key -> this.computePrefix(targetClass, method));
        String a = this.getParameters(params);
        return prefix + a;
    }

    protected String computePrefix(Class<?> targetClass, Method method) {
        String p = this.getPackage(targetClass);
        String t = this.getType(targetClass);
        String m = this.getMethod(method);
        return String.format("%s.%s#%s", p, t, m);
    }

    protected String getPackage(Class<?> targetClass) {
        String packageName = targetClass.getPackage().getName();
        StringJoiner stringJoiner = new StringJoiner(".");
        Arrays.stream(packageName.split("\\.")).map(s -> String.valueOf(s.charAt(0))).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    protected String getType(Class<?> targetClass) {
        return targetClass.getSimpleName();
    }

    protected String getMethod(Method method) {
        return method.getName();
    }

    protected String getParameters(Object ... params) {
        Object key = SimpleKeyGenerator.generateKey((Object[])params);
        return key.toString().substring(GET_A_OFFSET);
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }
}

