/*
 * Decompiled with CFR 0.152.
 */
package io.github.ms100.cacheasmulti.support.redis;

import io.github.ms100.cacheasmulti.support.redis.RedisCacheCustomizerUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.cache.RedisCacheManagerBuilderCustomizer;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;

@Order
public class RedisCacheTtlCustomizer
implements RedisCacheManagerBuilderCustomizer {
    private Map<String, Duration> cacheNameTimeToLiveMap = Collections.emptyMap();

    public void customize(RedisCacheManager.RedisCacheManagerBuilder builder) {
        RedisCacheConfiguration defaultCacheConfiguration = RedisCacheCustomizerUtils.getDefaultCacheConfigurationFor(builder);
        this.cacheNameTimeToLiveMap.forEach((cacheName, ttl) -> {
            RedisCacheConfiguration configuration = defaultCacheConfiguration.entryTtl(ttl);
            builder.withCacheConfiguration(cacheName, configuration);
        });
    }

    public Map<String, Duration> getCacheNameTimeToLiveMap() {
        return this.cacheNameTimeToLiveMap;
    }

    public void setCacheNameTimeToLiveMap(Map<String, Duration> cacheNameTimeToLiveMap) {
        this.cacheNameTimeToLiveMap = cacheNameTimeToLiveMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisCacheTtlCustomizer)) {
            return false;
        }
        RedisCacheTtlCustomizer other = (RedisCacheTtlCustomizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Duration> this$cacheNameTimeToLiveMap = this.getCacheNameTimeToLiveMap();
        Map<String, Duration> other$cacheNameTimeToLiveMap = other.getCacheNameTimeToLiveMap();
        return !(this$cacheNameTimeToLiveMap == null ? other$cacheNameTimeToLiveMap != null : !((Object)this$cacheNameTimeToLiveMap).equals(other$cacheNameTimeToLiveMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisCacheTtlCustomizer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Duration> $cacheNameTimeToLiveMap = this.getCacheNameTimeToLiveMap();
        result = result * 59 + ($cacheNameTimeToLiveMap == null ? 43 : ((Object)$cacheNameTimeToLiveMap).hashCode());
        return result;
    }

    public String toString() {
        return "RedisCacheTtlCustomizer(cacheNameTimeToLiveMap=" + this.getCacheNameTimeToLiveMap() + ")";
    }
}

