/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.SnapshotContext;
import au.com.origin.snapshots.SnapshotProperties;
import au.com.origin.snapshots.SnapshotVerifier;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Expect {
    private final SnapshotVerifier snapshotVerifier;
    private final Method testMethod;
    private SnapshotSerializer snapshotSerializer;
    private SnapshotComparator snapshotComparator;
    private List<SnapshotReporter> snapshotReporters;
    private String scenario;
    private final Map<String, String> headers = new HashMap<String, String>();

    public static Expect of(SnapshotVerifier snapshotVerifier, Method method) {
        return new Expect(snapshotVerifier, method);
    }

    public void toMatchSnapshot(Object object) {
        SnapshotContext snapshotContext = this.snapshotVerifier.expectCondition(this.testMethod, object);
        if (this.snapshotSerializer != null) {
            snapshotContext.setSnapshotSerializer(this.snapshotSerializer);
        }
        if (this.snapshotComparator != null) {
            snapshotContext.setSnapshotComparator(this.snapshotComparator);
        }
        if (this.snapshotReporters != null) {
            snapshotContext.setSnapshotReporters(this.snapshotReporters);
        }
        if (this.scenario != null) {
            snapshotContext.setScenario(this.scenario);
        }
        snapshotContext.header.putAll(this.headers);
        snapshotContext.checkValidContext();
        snapshotContext.toMatchSnapshot();
    }

    public Expect scenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    public Expect serializer(SnapshotSerializer serializer) {
        this.snapshotSerializer = serializer;
        return this;
    }

    public Expect serializer(String name) {
        this.snapshotSerializer = (SnapshotSerializer)SnapshotProperties.getInstance("serializer." + name);
        return this;
    }

    public Expect comparator(SnapshotComparator comparator) {
        this.snapshotComparator = comparator;
        return this;
    }

    public Expect comparator(String name) {
        this.snapshotComparator = (SnapshotComparator)SnapshotProperties.getInstance("comparator." + name);
        return this;
    }

    public Expect reporters(SnapshotReporter ... reporters) {
        this.snapshotReporters = Arrays.asList(reporters);
        return this;
    }

    public Expect reporters(String name) {
        this.snapshotReporters = SnapshotProperties.getInstances("reporters." + name);
        return this;
    }

    public Expect serializer(Class<? extends SnapshotSerializer> serializer) {
        this.snapshotSerializer = serializer.getConstructor(new Class[0]).newInstance(new Object[0]);
        return this;
    }

    public Expect header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Expect(SnapshotVerifier snapshotVerifier, Method testMethod) {
        this.snapshotVerifier = snapshotVerifier;
        this.testMethod = testMethod;
    }
}

