/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFile {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFile.class);
    public static final String SPLIT_STRING = "\n\n\n";
    private final String fileName;
    private final Class<?> testClass;
    private Set<Snapshot> snapshots = Collections.synchronizedSortedSet(new TreeSet());
    private Set<Snapshot> debugSnapshots = Collections.synchronizedSortedSet(new TreeSet());

    SnapshotFile(String srcDirPath, String fileName, Class<?> testClass) throws IOException {
        this.testClass = testClass;
        this.fileName = srcDirPath + File.separator + fileName;
        log.info("Snapshot File: " + this.fileName);
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), StandardCharsets.UTF_8));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                fileContent.append(sCurrentLine + "\n");
            }
            String fileText = fileContent.toString();
            if (!"".equals(fileText.trim())) {
                this.snapshots = Collections.synchronizedSortedSet(Stream.of(fileContent.toString().split(SPLIT_STRING)).map(String::trim).map(Snapshot::parse).collect(Collectors.toCollection(TreeSet::new)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteDebugFile();
    }

    private String getDebugFilename() {
        return this.fileName + ".debug";
    }

    public File createDebugFile(Snapshot snapshot) {
        File file = null;
        try {
            file = new File(this.getDebugFilename());
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream fileStream = new FileOutputStream(file, false);){
                fileStream.write(snapshot.raw().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void deleteDebugFile() {
        Files.deleteIfExists(Paths.get(this.getDebugFilename(), new String[0]));
    }

    public void delete() {
        Files.deleteIfExists(Paths.get(this.fileName, new String[0]));
    }

    public synchronized File createFileIfNotExists(String filename) {
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        return path.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushSnapshot(Snapshot snapshot) {
        Set<Snapshot> set = this.snapshots;
        synchronized (set) {
            this.snapshots.add(snapshot);
            TreeSet rawSnapshots = this.snapshots.stream().map(Snapshot::raw).collect(Collectors.toCollection(TreeSet::new));
            this.updateFile(this.fileName, rawSnapshots);
        }
    }

    public synchronized void pushDebugSnapshot(Snapshot snapshot) {
        this.debugSnapshots.add(snapshot);
        TreeSet rawDebugSnapshots = this.debugSnapshots.stream().map(Snapshot::raw).collect(Collectors.toCollection(TreeSet::new));
        this.updateFile(this.getDebugFilename(), rawDebugSnapshots);
    }

    private void updateFile(String fileName, Set<String> rawSnapshots) {
        File file = this.createFileIfNotExists(fileName);
        try (FileOutputStream fileStream = new FileOutputStream(file, false);){
            byte[] myBytes = String.join((CharSequence)SPLIT_STRING, rawSnapshots).getBytes(StandardCharsets.UTF_8);
            fileStream.write(myBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        Path path = Paths.get(this.fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.size(path) == 0L || this.snapshotsAreTheSame()) {
                this.deleteDebugFile();
            }
            if (Files.size(path) == 0L) {
                this.delete();
            } else {
                String content = new String(Files.readAllBytes(Paths.get(this.fileName, new String[0])), StandardCharsets.UTF_8);
                Files.write(path, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    private boolean snapshotsAreTheSame() {
        Path path = Paths.get(this.getDebugFilename(), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> snapshotFileContent = Files.readAllLines(Paths.get(this.fileName, new String[0]), StandardCharsets.UTF_8);
            List<String> debugSnapshotFileContent = Files.readAllLines(Paths.get(this.getDebugFilename(), new String[0]), StandardCharsets.UTF_8);
            return Objects.equals(snapshotFileContent, debugSnapshotFileContent);
        }
        return false;
    }

    public Set<Snapshot> getSnapshots() {
        return this.snapshots;
    }
}

