/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.config;

import au.com.origin.snapshots.SnapshotProperties;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.config.SnapshotConfig;
import au.com.origin.snapshots.exceptions.MissingSnapshotPropertiesKeyException;
import au.com.origin.snapshots.logging.LoggingHelper;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolvingSnapshotConfig
implements SnapshotConfig {
    private static final Logger log = LoggerFactory.getLogger(PropertyResolvingSnapshotConfig.class);

    @Override
    public String getOutputDir() {
        return SnapshotProperties.getOrThrow("output-dir");
    }

    @Override
    public String getSnapshotDir() {
        return SnapshotProperties.getOrThrow("snapshot-dir");
    }

    @Override
    public Optional<String> updateSnapshot() {
        Optional<String> legacyFlag = Optional.ofNullable(System.getProperty("updateSnapshot"));
        if (legacyFlag.isPresent()) {
            LoggingHelper.deprecatedV5(log, "Passing -PupdateSnapshot will be removed in a future release. Consider using snapshot.properties 'update-snapshot' toggle instead");
            if ("false".equals(legacyFlag.get())) {
                return Optional.empty();
            }
            return legacyFlag;
        }
        try {
            String updateSnapshot = SnapshotProperties.getOrThrow("update-snapshot");
            if ("all".equals(updateSnapshot)) {
                return Optional.of("");
            }
            if ("none".equals(updateSnapshot)) {
                return Optional.empty();
            }
            return Optional.of(updateSnapshot);
        }
        catch (MissingSnapshotPropertiesKeyException ex) {
            LoggingHelper.deprecatedV5(log, "You do not have 'update-snapshot=none' defined in your snapshot.properties - consider adding it now");
            return Optional.empty();
        }
    }

    @Override
    public SnapshotSerializer getSerializer() {
        return (SnapshotSerializer)SnapshotProperties.getInstance("serializer");
    }

    @Override
    public SnapshotComparator getComparator() {
        return (SnapshotComparator)SnapshotProperties.getInstance("comparator");
    }

    @Override
    public List<SnapshotReporter> getReporters() {
        return SnapshotProperties.getInstances("reporters");
    }

    @Override
    public boolean isCI() {
        String envVariable = SnapshotProperties.getOrThrow("ci-env-var");
        return System.getenv(envVariable) != null;
    }
}

