/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.api.AbstractIntegerAssert;
import shadow.org.assertj.core.api.AbstractIterableSizeAssert;
import shadow.org.assertj.core.api.AbstractListAssert;
import shadow.org.assertj.core.api.AbstractObjectArrayAssert;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.api.Assertions;
import shadow.org.assertj.core.api.Condition;
import shadow.org.assertj.core.api.IterableAssert;
import shadow.org.assertj.core.api.IterableSizeAssert;
import shadow.org.assertj.core.api.ObjectAssert;
import shadow.org.assertj.core.api.ObjectEnumerableAssert;
import shadow.org.assertj.core.api.filter.FilterOperator;
import shadow.org.assertj.core.api.filter.Filters;
import shadow.org.assertj.core.api.iterable.Extractor;
import shadow.org.assertj.core.api.iterable.ThrowingExtractor;
import shadow.org.assertj.core.description.Description;
import shadow.org.assertj.core.extractor.Extractors;
import shadow.org.assertj.core.groups.FieldsOrPropertiesExtractor;
import shadow.org.assertj.core.groups.Tuple;
import shadow.org.assertj.core.internal.CommonErrors;
import shadow.org.assertj.core.internal.CommonValidations;
import shadow.org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.ExtendedByTypesComparator;
import shadow.org.assertj.core.internal.FieldByFieldComparator;
import shadow.org.assertj.core.internal.IgnoringFieldsComparator;
import shadow.org.assertj.core.internal.IterableElementComparisonStrategy;
import shadow.org.assertj.core.internal.Iterables;
import shadow.org.assertj.core.internal.ObjectArrays;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.internal.OnFieldsComparator;
import shadow.org.assertj.core.internal.RecursiveFieldByFieldComparator;
import shadow.org.assertj.core.internal.TypeComparators;
import shadow.org.assertj.core.presentation.PredicateDescription;
import shadow.org.assertj.core.util.CheckReturnValue;
import shadow.org.assertj.core.util.IterableUtil;
import shadow.org.assertj.core.util.Lists;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.Strings;

public abstract class AbstractIterableAssert<SELF extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractAssert<SELF, ACTUAL>
implements ObjectEnumerableAssert<SELF, ELEMENT> {
    private static final String ASSERT = "Assert";
    private TypeComparators comparatorsByType;
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new TreeMap();
    private TypeComparators comparatorsForElementPropertyOrFieldTypes;
    protected Iterables iterables = Iterables.instance();

    public AbstractIterableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected static <T> Iterable<T> toLazyIterable(Iterator<T> actual) {
        if (actual == null) {
            return null;
        }
        return new IterableAssert.LazyIterable<T>(actual);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public void hasOnlyOneElementSatisfying(Consumer<ELEMENT> elementAssertions) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, 1);
        elementAssertions.accept(((Iterable)this.actual).iterator().next());
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnly(ELEMENT ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnlyOnce(ELEMENT ... values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnlyNulls() {
        this.iterables.assertContainsOnlyNulls(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactly(ELEMENT ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrder(ELEMENT ... values) {
        this.iterables.assertContainsExactlyInAnyOrder(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrderElementsOf(Iterable<? extends ELEMENT> values) {
        return (SELF)this.containsExactlyInAnyOrder((Object[])IterableUtil.toArray(values));
    }

    @Override
    public SELF isSubsetOf(Iterable<? extends ELEMENT> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(ELEMENT ... values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, Arrays.asList(values));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSequence(ELEMENT ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(ELEMENT ... sequence) {
        this.iterables.assertDoesNotContainSequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.iterables.assertDoesNotContainSequence(this.info, (Iterable)this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(ELEMENT ... subsequence) {
        this.iterables.assertContainsSubsequence((AssertionInfo)this.info, (Iterable)this.actual, subsequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.iterables.assertContainsSubsequence((AssertionInfo)this.info, (Iterable)this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(ELEMENT ... subsequence) {
        this.iterables.assertDoesNotContainSubsequence(this.info, (Iterable)this.actual, subsequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.iterables.assertDoesNotContainSubsequence(this.info, (Iterable)this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF startsWith(ELEMENT ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT first, ELEMENT ... rest) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, first, rest);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT[] sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF are(Condition<? super ELEMENT> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areNot(Condition<? super ELEMENT> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF have(Condition<? super ELEMENT> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doNotHave(Condition<? super ELEMENT> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeastOne(Condition<? super ELEMENT> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtLeastOne(Condition<? super ELEMENT> condition) {
        return (SELF)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public SELF haveAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasAtLeastOneElementOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasAtLeastOneElementOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasOnlyElementsOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveAnyElementsOfTypes(Class<?> ... unexpectedTypes) {
        ObjectArrays.instance().assertDoesNotHaveAnyElementsOfTypes(this.info, IterableUtil.toArray((Iterable)this.actual), unexpectedTypes);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfTypes(Class<?> ... types) {
        ObjectArrays.instance().assertHasOnlyElementsOfTypes(this.info, IterableUtil.toArray((Iterable)this.actual), types);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsAll(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super ELEMENT> elementComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new IterableElementComparisonStrategy<ELEMENT>(elementComparator));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    private SELF usingExtendedByTypesElementComparator(Comparator<Object> elementComparator) {
        return (SELF)this.usingElementComparator((Comparator)new ExtendedByTypesComparator(elementComparator, this.getComparatorsByType()));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.iterables = Iterables.instance();
        return (SELF)this.usingDefaultComparator();
    }

    @Override
    public SELF containsAnyOf(ELEMENT ... values) {
        this.iterables.assertContainsAnyOf(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsAnyOf((Object[])IterableUtil.toArray(iterable));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        String extractedDescription = Extractors.extractedDescriptionOf(propertyOrField);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extractingResultOf(String method) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        String extractedDescription = Extractors.extractedDescriptionOf(propertyOrField);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertiesOrFields));
        String extractedDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extracting(Extractor<? super ELEMENT, V> extractor) {
        List<V> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return this.newListAssertInstanceForMethodsChangingElementType(values);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extracting(ThrowingExtractor<? super ELEMENT, V, EXCEPTION> extractor) {
        List values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return this.newListAssertInstanceForMethodsChangingElementType(values);
    }

    private <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> newListAssertInstanceForMethodsChangingElementType(List<V> values) {
        if (this.actual instanceof SortedSet) {
            this.usingDefaultElementComparator();
        }
        return (AbstractListAssert)this.newListAssertInstance(values).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(Extractor<? super ELEMENT, ? extends Collection<V>> extractor) {
        return this.doFlatExtracting(extractor);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(ThrowingExtractor<? super ELEMENT, ? extends Collection<V>, EXCEPTION> extractor) {
        return this.doFlatExtracting(extractor);
    }

    private <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> doFlatExtracting(Extractor<? super ELEMENT, ? extends Collection<V>> extractor) {
        List result = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor).stream().flatMap(Collection::stream).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(result);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(Extractor<? super ELEMENT, ?> ... extractors) {
        Stream<Object> actualStream = StreamSupport.stream(((Iterable)this.actual).spliterator(), false);
        List result = actualStream.flatMap(element -> Stream.of(extractors).map(extractor -> extractor.extract(element))).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(result);
    }

    @CheckReturnValue
    public <EXCEPTION extends Exception> AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... extractors) {
        Stream<Object> actualStream = StreamSupport.stream(((Iterable)this.actual).spliterator(), false);
        List result = actualStream.flatMap(element -> Stream.of(extractors).map(extractor -> extractor.extract(element))).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(result);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String fieldOrPropertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyName));
        for (Object group : extractedGroups) {
            if (shadow.org.assertj.core.util.Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return this.newListAssertInstanceForMethodsChangingElementType(extractedValues);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(Function<ELEMENT, ?> ... extractors) {
        Function<Object, Tuple> tupleExtractor = objectToExtractValueFrom -> new Tuple(Stream.of(extractors).map(extractor -> extractor.apply(objectToExtractValueFrom)).toArray());
        List tuples = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).map(tupleExtractor).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(tuples);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String ... fieldOrPropertyNames) {
        List extractedValues = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyNames)).stream().flatMap(tuple -> tuple.toList().stream()).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(extractedValues);
    }

    @Override
    public SELF containsExactlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsOnlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF hasSameElementsAs(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnlyElementsOf((Iterable)iterable);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForElementFieldsWithNames(Comparator<T> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForElementFieldsWithType(Comparator<T> comparator, Class<T> type) {
        this.getComparatorsForElementPropertyOrFieldTypes().put(type, comparator);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForType(Comparator<T> comparator, Class<T> type) {
        if (this.iterables.getComparator() == null) {
            this.usingElementComparator((Comparator)new ExtendedByTypesComparator(this.getComparatorsByType()));
        }
        this.getComparatorsForElementPropertyOrFieldTypes().put(type, comparator);
        this.getComparatorsByType().put(type, comparator);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes()));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes()));
    }

    @CheckReturnValue
    public SELF usingElementComparatorOnFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    protected SELF usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        this.iterables = new Iterables(comparisonStrategy);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingElementComparatorIgnoringFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractIterableAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractIterableAssert)super.inBinary());
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, Object expectedValue) {
        Filters filter = Filters.filter((Iterable)this.actual);
        List filteredIterable = filter.with(propertyOrFieldName, expectedValue).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOnNull(String propertyOrFieldName) {
        Filters filter = Filters.filter((Iterable)this.actual);
        List filteredIterable = filter.with(propertyOrFieldName, null).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters filter = Filters.filter((Iterable)this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filter.get())).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOn(Condition<? super ELEMENT> condition) {
        Filters<? super ELEMENT> filter = Filters.filter((Iterable)this.actual);
        List<? super ELEMENT> filteredIterable = filter.being(condition).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    public SELF filteredOnAssertions(Consumer<? super ELEMENT> elementAssertions) {
        Preconditions.checkArgument(elementAssertions != null, "The element assertions should not be null", new Object[0]);
        List filteredIterable = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).filter(Iterables.byPassingAssertions(elementAssertions)).collect(Collectors.toList());
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public ELEMENT_ASSERT first() {
        this.isNotEmpty();
        return this.toAssert(((Iterable)this.actual).iterator().next(), this.navigationDescription("check first element"));
    }

    @CheckReturnValue
    public ELEMENT_ASSERT last() {
        this.isNotEmpty();
        return this.toAssert(this.lastElement(), this.navigationDescription("check last element"));
    }

    private ELEMENT lastElement() {
        if (this.actual instanceof List) {
            List list = (List)this.actual;
            return (ELEMENT)list.get(list.size() - 1);
        }
        Iterator actualIterator = ((Iterable)this.actual).iterator();
        Object last = actualIterator.next();
        while (actualIterator.hasNext()) {
            last = actualIterator.next();
        }
        return (ELEMENT)last;
    }

    @CheckReturnValue
    public ELEMENT_ASSERT element(int index) {
        this.isNotEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat(index).describedAs(this.navigationDescription("check index validity"), new Object[0])).isBetween(0, IterableUtil.sizeOf((Iterable)this.actual) - 1);
        ELEMENT elementAtIndex = null;
        if (this.actual instanceof List) {
            List list = (List)this.actual;
            elementAtIndex = (ELEMENT)list.get(index);
        } else {
            Iterator actualIterator = ((Iterable)this.actual).iterator();
            for (int i = 0; i < index; ++i) {
                actualIterator.next();
            }
            elementAtIndex = (ELEMENT)actualIterator.next();
        }
        return this.toAssert(elementAtIndex, this.navigationDescription("element at index " + index));
    }

    protected abstract ELEMENT_ASSERT toAssert(ELEMENT var1, String var2);

    protected String navigationDescription(String propertyName) {
        String text = this.descriptionText();
        if (Strings.isNullOrEmpty(text)) {
            text = AbstractIterableAssert.removeAssert(this.getClass().getSimpleName());
        }
        return text + " " + propertyName;
    }

    private static String removeAssert(String text) {
        return text.endsWith(ASSERT) ? text.substring(0, text.length() - ASSERT.length()) : text;
    }

    public SELF filteredOn(Predicate<? super ELEMENT> predicate) {
        Preconditions.checkArgument(predicate != null, "The filter predicate should not be null", new Object[0]);
        List filteredIterable = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).filter(predicate).collect(Collectors.toList());
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAllMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate, String predicateDescription) {
        this.iterables.assertAllMatch(this.info, (Iterable)this.actual, predicate, new PredicateDescription(predicateDescription));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF allSatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAllSatisfy(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF anyMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAnyMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public <OTHER_ELEMENT> SELF zipSatisfy(Iterable<OTHER_ELEMENT> other, BiConsumer<? super ELEMENT, OTHER_ELEMENT> zipRequirements) {
        this.iterables.assertZipSatisfy(this.info, (Iterable)this.actual, other, zipRequirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF anySatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAnySatisfy(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF noneSatisfy(Consumer<? super ELEMENT> restrictions) {
        this.iterables.assertNoneSatisfy(this.info, (Iterable)this.actual, restrictions);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.as(description, args));
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractIterableAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description, args));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.has((Condition)condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractIterableAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.is((Condition)condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isIn((Iterable)values));
    }

    @Override
    public SELF isIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isIn(values));
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.isNot((Condition)condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public SELF isNotIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn(values));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractIterableAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isSameAs(expected));
    }

    @Override
    public SELF noneMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertNoneMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractIterableAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        return (SELF)((AbstractIterableAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractIterableAssert)super.withThreadDumpOnError());
    }

    @CheckReturnValue
    public AbstractIterableSizeAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> size() {
        Preconditions.checkNotNull(this.actual, "Can not perform assertions on the size of a null iterable.");
        return new IterableSizeAssert(this, IterableUtil.sizeOf((Iterable)this.actual));
    }

    protected TypeComparators getComparatorsByType() {
        if (this.comparatorsByType == null) {
            this.comparatorsByType = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsByType;
    }

    protected TypeComparators getComparatorsForElementPropertyOrFieldTypes() {
        if (this.comparatorsForElementPropertyOrFieldTypes == null) {
            this.comparatorsForElementPropertyOrFieldTypes = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsForElementPropertyOrFieldTypes;
    }

    protected abstract SELF newAbstractIterableAssert(Iterable<? extends ELEMENT> var1);

    @Override
    SELF withAssertionState(AbstractAssert assertInstance) {
        if (assertInstance instanceof AbstractIterableAssert) {
            AbstractIterableAssert iterableAssert = (AbstractIterableAssert)assertInstance;
            return ((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)super.withAssertionState(assertInstance)).withIterables(iterableAssert.iterables)).withTypeComparators(iterableAssert.comparatorsByType)).withComparatorsForElementPropertyOrFieldNames(iterableAssert.comparatorsForElementPropertyOrFieldNames)).withComparatorsForElementPropertyOrFieldTypes(iterableAssert.comparatorsForElementPropertyOrFieldTypes);
        }
        if (assertInstance instanceof AbstractObjectArrayAssert) {
            AbstractObjectArrayAssert objectArrayAssert = (AbstractObjectArrayAssert)assertInstance;
            return ((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)super.withAssertionState(assertInstance)).withIterables(objectArrayAssert.iterables)).withTypeComparators(objectArrayAssert.comparatorsByType)).withComparatorsForElementPropertyOrFieldNames(objectArrayAssert.comparatorsForElementPropertyOrFieldNames)).withComparatorsForElementPropertyOrFieldTypes(objectArrayAssert.comparatorsForElementPropertyOrFieldTypes);
        }
        return (SELF)((AbstractIterableAssert)super.withAssertionState(assertInstance));
    }

    SELF withIterables(Iterables iterables) {
        this.iterables = iterables;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withTypeComparators(TypeComparators comparatorsByType) {
        this.comparatorsByType = comparatorsByType;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withComparatorsForElementPropertyOrFieldNames(Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames) {
        this.comparatorsForElementPropertyOrFieldNames = comparatorsForElementPropertyOrFieldNames;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withComparatorsForElementPropertyOrFieldTypes(TypeComparators comparatorsForElementPropertyOrFieldTypes) {
        this.comparatorsForElementPropertyOrFieldTypes = comparatorsForElementPropertyOrFieldTypes;
        return (SELF)((AbstractIterableAssert)this.myself);
    }
}

