/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import shadow.org.assertj.core.error.AbstractShouldHaveTextContent;
import shadow.org.assertj.core.error.ErrorMessageFactory;
import shadow.org.assertj.core.util.diff.Delta;

public class ShouldHaveSameContent
extends AbstractShouldHaveTextContent {
    public static ErrorMessageFactory shouldHaveSameContent(File actual, File expected, List<Delta<String>> diffs) {
        return new ShouldHaveSameContent(actual, expected, ShouldHaveSameContent.diffsAsString(diffs));
    }

    public static ErrorMessageFactory shouldHaveSameContent(InputStream actual, InputStream expected, List<Delta<String>> diffs) {
        return new ShouldHaveSameContent(actual, expected, ShouldHaveSameContent.diffsAsString(diffs));
    }

    public static ErrorMessageFactory shouldHaveSameContent(InputStream actual, String expected, List<Delta<String>> diffs) {
        return new ShouldHaveSameContent(actual, expected, ShouldHaveSameContent.diffsAsString(diffs));
    }

    public static ErrorMessageFactory shouldHaveSameContent(Path actual, Path expected, List<Delta<String>> diffs) {
        return new ShouldHaveSameContent(actual, expected, ShouldHaveSameContent.diffsAsString(diffs));
    }

    private ShouldHaveSameContent(File actual, File expected, String diffs) {
        super("%nFile:%n  <%s>%nand file:%n  <%s>%ndo not have same content:%n%n", actual, expected);
        this.diffs = diffs;
    }

    private ShouldHaveSameContent(InputStream actual, InputStream expected, String diffs) {
        super("%nInputStreams do not have same content:%n%n", actual, expected);
        this.diffs = diffs;
    }

    private ShouldHaveSameContent(InputStream actual, String expected, String diffs) {
        super("%nInputStream does not have same content as String:%n%n", actual, expected);
        this.diffs = diffs;
    }

    private ShouldHaveSameContent(Path actual, Path expected, String diffs) {
        super("%nPath:%n  <%s>%nand path:%n  <%s>%ndo not have same content:%n%n", actual, expected);
        this.diffs = diffs;
    }
}

